% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TableStyle.R
\docType{class}
\name{TableStyle}
\alias{TableStyle}
\title{R6 class that specifies styling.}
\format{
\code{\link[R6]{R6Class}} object.
}
\description{
The `TableStyle` class specifies the styling for headers and cells in a
table.  Styles are specified in the form of Cascading Style Sheet (CSS)
name-value pairs.
}
\examples{
# TableStyle objects are normally created indirectly via one of the helper
# methods.
# For an example, see the `TableStyles` class.
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{name}}{The unique name of the style (must be unique among the style
names in the table theme).}

\item{\code{declarations}}{A list containing CSS style declarations.
Example: `declarations = list(font="...", color="...")`}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-TableStyle-new}{\code{TableStyle$new()}}
\item \href{#method-TableStyle-setPropertyValue}{\code{TableStyle$setPropertyValue()}}
\item \href{#method-TableStyle-setPropertyValues}{\code{TableStyle$setPropertyValues()}}
\item \href{#method-TableStyle-getPropertyValue}{\code{TableStyle$getPropertyValue()}}
\item \href{#method-TableStyle-asCSSRule}{\code{TableStyle$asCSSRule()}}
\item \href{#method-TableStyle-asNamedCSSStyle}{\code{TableStyle$asNamedCSSStyle()}}
\item \href{#method-TableStyle-getCopy}{\code{TableStyle$getCopy()}}
\item \href{#method-TableStyle-asList}{\code{TableStyle$asList()}}
\item \href{#method-TableStyle-asJSON}{\code{TableStyle$asJSON()}}
\item \href{#method-TableStyle-clone}{\code{TableStyle$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TableStyle-new"></a>}}
\if{latex}{\out{\hypertarget{method-TableStyle-new}{}}}
\subsection{Method \code{new()}}{
Create a new `TableStyle` object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TableStyle$new(parentTable, styleName = NULL, declarations = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{parentTable}}{Owning table.}

\item{\code{styleName}}{A unique name for the style.}

\item{\code{declarations}}{A list containing CSS style declarations.
Example: `declarations = list(font="...", color="...")`}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
No return value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TableStyle-setPropertyValue"></a>}}
\if{latex}{\out{\hypertarget{method-TableStyle-setPropertyValue}{}}}
\subsection{Method \code{setPropertyValue()}}{
Set the value of a single style property.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TableStyle$setPropertyValue(property = NULL, value = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{property}}{The CSS style property name, e.g. color.}

\item{\code{value}}{The value of the style property, e.g. red.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
No return value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TableStyle-setPropertyValues"></a>}}
\if{latex}{\out{\hypertarget{method-TableStyle-setPropertyValues}{}}}
\subsection{Method \code{setPropertyValues()}}{
Set the values of multiple style properties.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TableStyle$setPropertyValues(declarations = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{declarations}}{A list containing CSS style declarations.
Example: `declarations = list(font="...", color="...")`}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
No return value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TableStyle-getPropertyValue"></a>}}
\if{latex}{\out{\hypertarget{method-TableStyle-getPropertyValue}{}}}
\subsection{Method \code{getPropertyValue()}}{
Get the value of a single style property.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TableStyle$getPropertyValue(property = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{property}}{The CSS style property name, e.g. color.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
No return value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TableStyle-asCSSRule"></a>}}
\if{latex}{\out{\hypertarget{method-TableStyle-asCSSRule}{}}}
\subsection{Method \code{asCSSRule()}}{
Generate a CSS style rule from this table style.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TableStyle$asCSSRule(selector = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{selector}}{The CSS selector name.  Default value `NULL`.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The CSS style rule, e.g. \{ text-align: center; color: red; \}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TableStyle-asNamedCSSStyle"></a>}}
\if{latex}{\out{\hypertarget{method-TableStyle-asNamedCSSStyle}{}}}
\subsection{Method \code{asNamedCSSStyle()}}{
Generate a named CSS style from this table style.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TableStyle$asNamedCSSStyle(styleNamePrefix = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{styleNamePrefix}}{A character variable specifying a prefix for all named
CSS styles, to avoid style name collisions where multiple tables exist.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The CSS style rule, e.g. cell \{ text-align: center; color: red; \}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TableStyle-getCopy"></a>}}
\if{latex}{\out{\hypertarget{method-TableStyle-getCopy}{}}}
\subsection{Method \code{getCopy()}}{
Create a copy of this `TableStyle` object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TableStyle$getCopy(newStyleName = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{newStyleName}}{The name of the new style.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The new `TableStyle` object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TableStyle-asList"></a>}}
\if{latex}{\out{\hypertarget{method-TableStyle-asList}{}}}
\subsection{Method \code{asList()}}{
Return the contents of this object as a list for debugging.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TableStyle$asList()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list of various object properties.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TableStyle-asJSON"></a>}}
\if{latex}{\out{\hypertarget{method-TableStyle-asJSON}{}}}
\subsection{Method \code{asJSON()}}{
Return the contents of this object as JSON for debugging.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TableStyle$asJSON()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A JSON representation of various object properties.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TableStyle-clone"></a>}}
\if{latex}{\out{\hypertarget{method-TableStyle-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TableStyle$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
