% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_outputs.R
\name{get.mig.convergence}
\alias{get.mig.convergence}
\alias{get.mig.convergence.all}
\title{Accessing Convergence Diagnostics Object}
\usage{
get.mig.convergence(sim.dir, thin = 225, burnin = 10000)

get.mig.convergence.all(sim.dir)
}
\arguments{
\item{sim.dir}{Simulation directory used for computing the diagnostics.}

\item{thin}{Thinning interval used with this diagnostics.}

\item{burnin}{Burn-in used for computing the diagnostics.}
}
\value{
\code{get.mig.convergence} returns an object of class \code{\link{bayesMig.convergence}}; \cr
    \code{get.mig.convergence.all} returns a list of objects of class \code{\link{bayesMig.convergence}}.
}
\description{
The function retrieves results of convergence diagnostics 
    (created by \code{\link{mig.diagnose}}) from disk.
}
\details{
Function \code{get.mig.convergence} loads an object of class 
    \code{\link{bayesMig.convergence}} for the specific \code{thin} and \code{burnin} 
    used in \code{\link{mig.diagnose}} to generate this object. 
    Function \code{get.mig.convergence.all} loads all \code{\link{bayesMig.convergence}} objects 
    available in \code{sim.dir}.
}
\examples{
\donttest{
# Run a real simulation (can take long time)
sim.dir <- tempfile()
m <- run.mig.mcmc(nr.chains = 2, iter = 10000, thin = 10, output.dir = sim.dir)

# Run convergence diagnostics with different burning and thin
mig.diagnose(sim.dir, burnin = 1000, thin = 2)
mig.diagnose(sim.dir, burnin = 500, thin = 1)

diags <- get.mig.convergence.all(sim.dir)
for(i in 1:length(diags))
    print(summary(diags[[i]]))

unlink(sim.dir, recursive = TRUE)
}
}
\seealso{
\code{\link{mig.diagnose}}, \code{\link{summary.bayesMig.convergence}}
}
