% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayesweight_cen.R
\name{bayesweight_cen}
\alias{bayesweight_cen}
\title{Bayesian Treatment Effect Weight Estimation for Censored Data}
\usage{
bayesweight_cen(
  trtmodel.list,
  cenmodel.list,
  data,
  n.chains = 2,
  n.iter = 25000,
  n.burnin = 15000,
  n.thin = 5,
  seed = NULL,
  parallel = TRUE
)
}
\arguments{
\item{trtmodel.list}{A list of formulas corresponding to each time point with the time-specific treatment variable on the left-hand side and pre-treatment covariates to be balanced on the right-hand side. The formulas must be in temporal order, and must contain all covariates to be balanced at that time point. Interactions and functions of covariates are allowed.}

\item{cenmodel.list}{A list of formulas for the censored data at each time point, with censoring indicators on the left-hand side and covariates on the right-hand side. The formulas must be in temporal order, and must contain all covariates to be balanced at that time point.}

\item{data}{A data set in the form of a data frame containing the variables in "trtmodel.list" and "cenmodel.list". This must be a wide data set with exactly one row per unit.}

\item{n.chains}{Integer specifying the number of MCMC chains to run. Set to 1 for non-parallel computation. For parallel computation, it is required to use at least 2 chains. The default is 2.}

\item{n.iter}{Integer specifying the total number of iterations for each chain (including burn-in). The default is 25000.}

\item{n.burnin}{Integer specifying the number of burn-in iterations for each chain. The default is 15000.}

\item{n.thin}{Integer specifying the thinning rate for the MCMC sampler. The default is 5.}

\item{seed}{Starting seed for the JAGS model. The default is NULL.}

\item{parallel}{Logical scalar indicating whether to run the MCMC chains in parallel. The default is TRUE.}
}
\value{
A list of the calculated weights and the JAGS model where "weights" is a vector of posterior mean weights, computed by taking the average of the weights across all MCMC iterations and `model_string` is a character of the JAGS model based on the input of "trtmodel.list".
}
\description{
This function estimates Bayesian importance sampling weights for treatment models and censoring models across multiple time points via JAGS
}
\examples{
amodel <- list(
 c("(Intercept)" = -0.3, "L1_1" = 0.4, "L2_1" = -0.2),
 c("(Intercept)" = -0.1, "L1_2" = 0.3, "L2_2" = -0.1, "A_prev" = 0.5))
ymodel <- c(
"(Intercept)" = -0.8,
"A1"          = 0.2,
"A2"          = 0.4,
"L1_2"        = 0.3,
"L2_2"        = -0.3)
cmodel <- list(
 c("(Intercept)" = -1.5, "L1_1" = 0.2, "L2_1" = -0.2, "A" = 0.2),
 c("(Intercept)" = -1.5, "L1_2" = 0.1, "L2_2" = -0.1, "A" = 0.3))
testdata <- simData(
 n                = 50,
 n_visits         = 2,
 covariate_counts = c(2, 2),
 amodel           = amodel,
 ymodel           = ymodel,
 y_type           = "binary",
 right_censor     = TRUE,
 cmodel           = cmodel,
 seed             = 123
)
weights_cen <- bayesweight_cen(
                trtmodel.list = list(
                       A1 ~ L1_1 + L2_1,
                       A2 ~ L2_2 + L2_2 + A1),
                cenmodel.list = list(
                C1 ~ L1_1 + L2_1 + A1,
                C2 ~ L1_2 + L2_2 + A2),
                data = testdata,
                n.chains = 1,
                n.iter = 20,
                n.burnin = 10,
                n.thin = 1,
                seed = 890123,
                parallel = FALSE)
summary(weights_cen)
}
