% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/necsummary-class.R
\docType{class}
\name{necsummary-class}
\alias{necsummary-class}
\alias{necsummary}
\title{Class \code{necsummary} of models fitted with the \pkg{brms} package}
\description{
Single models fitted with the
\code{\link[bayesnec:bayesnec-package]{bayesnec}} package are summarised
as a \code{necsummary} object, which contains the original
\code{\link[brms]{brmsfit}} object summary, the name of the
non-linear model fitted, whether this model is an ECx-type model
(see details below), and the ECx summary values should the user decide
to calculate them.
}
\details{
See \code{methods(class = "necsummary")} for an overview of available
methods.
}
\section{Slots}{

\describe{
\item{\code{brmssummary}}{The standard summary for the fitted Bayesian model of
class \code{\link[brms]{brmsfit}}.}

\item{\code{model}}{A \code{\link[base]{character}} string indicating the name of
the fitted non-linear model.}

\item{\code{is_ecx}}{A \code{\link[base]{logical}} indicating whether \code{model}
is an ECx-type model.}

\item{\code{nec_vals}}{The NEC values. Note that if model is an ECx-type model,
this estimate will be a NSEC proxy.}

\item{\code{ecs}}{A \code{\link[base]{list}} containing the ECx values
should the user decide to calculate them (see the non-exported
\code{bayesnec:::summary.bayesnecfit} help file for details).}

\item{\code{bayesr2}}{The model Bayesian R2 as calculated by
\code{\link[brms]{bayes_R2}}.}
}}

\references{
Fisher R, Barneche DR, Ricardo GF, Fox, DR (2024) An {R} Package for
Concentration-Response Modeling and Estimation of Toxicity Metrics
doi:10.18637/jss.v110.i05.

Fisher R, Fox DR (2023). Introducing the no significant effect concentration
(NSEC).Environmental Toxicology and Chemistry, 42(9), 2019–2028.
doi: 10.1002/etc.5610.

Fisher R, Fox DR, Negri AP, van Dam J, Flores F, Koppel D (2023). Methods for
estimating no-effect toxicity concentrations in ecotoxicology. Integrated
Environmental Assessment and Management. doi:10.1002/ieam.4809.

Fox DR (2010). A Bayesian Approach for Determining the No Effect
Concentration and Hazardous Concentration in Ecotoxicology. Ecotoxicology
and Environmental Safety, 73(2), 123–131. doi: 10.1016/j.ecoenv.2009.09.012.
}
\seealso{
\code{\link{bayesnec}},
\code{\link{bnec}},
\code{\link{bayesnecfit}},
\code{\link{bayesmanecfit}},
\code{\link{manecsummary}}
}
