% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{calc_r2}
\alias{calc_r2}
\title{Calculate R-Squared for a Model}
\usage{
calc_r2(model)
}
\arguments{
\item{model}{A fitted model object. The model must have \code{resid()} and \code{fitted()} methods to extract residuals and fitted values.}
}
\value{
A numeric value representing the \eqn{R^2} value of the model. Returns \code{NA} if the model is \code{NULL}.
}
\description{
This function calculates the coefficient of determination (\eqn{R^2}) for a given model by comparing the sum of squared errors (SSE)
to the total sum of squares (SST).
}
\examples{
# Example using a simple linear model
data <- data.frame(x = 1:10, y = c(1, 2, 3, 4, 5, 6, 7, 9, 10, 11))
lm_model <- lm(y ~ x, data = data)
calc_r2(lm_model)
}
