% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{plot.hrest}
\alias{plot.hrest}
\title{plots the \code{hrest} object}
\usage{
\method{plot}{hrest}(x, ..., which = "rank_simulation")
}
\arguments{
\item{x}{the \code{hrest} object from \code{\link{estimate}}}

\item{...}{Other parameters}

\item{which}{the type of left hand panel to create. Either "rank_simulation"
or "just_data"}
}
\value{
ggplot object
}
\description{
returns a ggplot object representing the hrest object from
\code{\link{estimate}}. The content of left panel varies according to the
value of the \code{which} parameter. If \code{which = "rank_simulation"} is
used a plot of rank score values will be plotted in the left panel. In this
case technical replicates will be averaged if provided. If
\code{which = "just_data" } a plot of scores only is created and technical
replicates are displayed as is. In each case, the right hand panel shows the
rank bootstrap distribution and confidence interval boundaries for all non-
control groups.
}
\examples{

 d1 <- make_data()
 hr_est <- estimate(d1, score, group)
 plot(hr_est)

}
