% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DMC_identification.R
\name{DMC_identification}
\alias{DMC_identification}
\title{The DMC identification function}
\usage{
DMC_identification(
  object,
  data,
  CpG_site_list,
  threshold = 0.65,
  metric = "AUC"
)
}
\arguments{
\item{object}{A betaclust object}

\item{data}{A dataframe of dimension \eqn{C \times NR} containing methylation
values for \eqn{C} CpG sites from \eqn{R} samples collected from \eqn{N}
patients which was passed as an argument to the
\code{\link[betaclust:betaclust]{betaclust}} function.}

\item{CpG_site_list}{The IlmnID of all the CpG sites analysed by
\code{\link[betaclust:betaclust]{betaclust}} function.}

\item{threshold}{The threshold value/s for selecting the most differentially
methylated clusters, default= 0.65}

\item{metric}{The metric (AUC or WD selected). default="AUC"}
}
\value{
The function returns a dataframe of CpG sites and
 methylation values identified to belong to the most
  differentially methylated clusters
}
\description{
A function to identify the most differentially
methylated clusters from \eqn{K} clusters.
}
\details{
This function selects the most diffentially methylated clusters
based on AUC and WD metric calculated and returns the CpG sites
belonging to those clusters.
}
\examples{
\donttest{
my.seed <- 190
M <- 3
N <- 4
R <- 2
data_output <- betaclust(pca.methylation.data[1:30,2:9], M, N, R,
            model_names = "K.R",
            parallel_process = FALSE, seed = my.seed)
dmc_df <-DMC_identification(data_output,pca.methylation.data[1:30,2:9],
pca.methylation.data[1:30,1],
 threshold = 0.65, metric = "AUC")

}
}
\seealso{
\code{\link{beta_kr}}

\code{\link{pca.methylation.data}}

\code{\link{plot.betaclust}}

\code{\link{summary.betaclust}}

\code{\link{betaclust}}
}
