% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{psd_arma}
\alias{psd_arma}
\title{ARMA(p,q) spectral density function}
\usage{
psd_arma(freq, ar, ma, sigma2 = 1)
}
\arguments{
\item{freq}{numeric vector of frequencies to evaluate the psd, 0 <= freq < pi}

\item{ar}{autoregressive coefficients of ARMA model (use numeric(0) for empty AR part)}

\item{ma}{moving average coefficients of ARMA model (use numeric(0) for empty MA part)}

\item{sigma2}{the model innovation variance}
}
\value{
numeric vector of the (real-valued) spectral density values
}
\description{
Evaluate the ARMA(p,q) spectral density at some frequencies freq in [0,pi),
Note that no test for model stationarity is performed.
}
\details{
See section 4.4 in the referenced book
}
\references{
P. J. Brockwell and R. Davis (1996)
\emph{Time Series: Theory and Methods (Second Edition)}
}
