% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prediction_methods.R
\name{predictions}
\alias{predictions}
\alias{get_predictions}
\alias{get_predictions.default}
\alias{get_predictions.asreml}
\alias{get_predictions.lm}
\alias{get_predictions.lmerMod}
\alias{get_predictions.lmerModLmerTest}
\title{Get Predictions for Statistical Models}
\usage{
get_predictions(model.obj, classify, pred.obj = NULL, ...)

\method{get_predictions}{default}(model.obj, ...)

\method{get_predictions}{asreml}(model.obj, classify, pred.obj = NULL, ...)

\method{get_predictions}{lm}(model.obj, classify, ...)

\method{get_predictions}{lmerMod}(model.obj, classify, ...)

\method{get_predictions}{lmerModLmerTest}(model.obj, classify, ...)
}
\arguments{
\item{model.obj}{A model object. Currently supported model objects are asreml, aov/lm, lmerMod/lmerModLmerTest.}

\item{classify}{Name of predictor variable as a string.}

\item{pred.obj}{Optional precomputed prediction object.}

\item{...}{Additional arguments passed to specific methods.}
}
\value{
A list containing predictions, standard errors, degrees of freedom,
response variable label, and aliased names.
}
\description{
A generic function to get predictions for statistical models.
}
\keyword{internal}
