% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install_binaries.R
\name{install_binaries}
\alias{install_binaries}
\title{Download, unzip, check permissions, and test the bioregion's binary files}
\usage{
install_binaries(
  binpath = "tempdir",
  download_only = FALSE,
  infomap_version = c("2.1.0", "2.6.0", "2.7.1", "2.8.0")
)
}
\arguments{
\item{binpath}{A \code{character} string specifying the path to the folder that
will host the \code{bin} folder containing the binary files (see Details).}

\item{download_only}{A \code{logical} value indicating whether the function should
only download the \code{bin.zip} file or perform the entire process (see Details).}

\item{infomap_version}{A \code{character} vector or a single \code{character} string
specifying the Infomap version(s) to install.}
}
\value{
No return value.
}
\description{
This function downloads and unzips the 'bin' folder required to run certain
functions of the \code{bioregion} package. It also verifies if the files have the
necessary permissions to be executed as programs. Finally, it tests whether
the binary files are running correctly.
}
\details{
By default, the binary files are installed in R's temporary
directory (\code{binpath = "tempdir"}). In this case, the \code{bin} folder will be
automatically removed at the end of the R session. Alternatively, the binary
files can be installed in the \code{bioregion} package folder
(\code{binpath = "pkgfolder"}).

A custom folder path can also be specified. In this case, and only in this
case, \code{download_only} can be set to \code{TRUE}, but you must ensure that the
files have the required permissions to be executed as programs.

\strong{In all cases, PLEASE MAKE SURE to update the \code{binpath} and \code{check_install}
parameters accordingly in \link{netclu_infomap}, \link{netclu_louvain}, and
\link{netclu_oslom}.}
}
\note{
Currently, only Infomap versions 2.1.0, 2.6.0, 2.7.1, and 2.8.0 are available.
}
\seealso{
For more details illustrated with a practical example,
see the vignette:
\url{https://biorgeo.github.io/bioregion/articles/a1_install_binary_files.html}.
}
\author{
Maxime Lenormand (\email{maxime.lenormand@inrae.fr}) \cr
Boris Leroy (\email{leroy.boris@gmail.com}) \cr
Pierre Denelle (\email{pierre.denelle@gmail.com})
}
