% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aesthetics.R
\name{newaxes}
\alias{newaxes}
\title{Format aesthetics for the supplementary (new) biplot axes}
\usage{
newaxes(bp, X.new.names=bp$var.names, which = 1:bp$num.vars, col = "orange", lwd = 1, 
lty = 1, label.dir = "Orthog", label.col = col, label.cex = 0.75, label.line = 0.1, 
ticks = 5, tick.col = col, tick.size = 1, tick.label = TRUE, tick.label.col = tick.col, 
tick.label.cex = 0.6, tick.label.side = "below", predict.col = col, predict.lwd = lwd, 
predict.lty = lty, ax.names = X.new.names, orthogx = 0, orthogy = 0)
}
\arguments{
\item{bp}{an object of class \code{biplot}.}

\item{X.new.names}{a vector of the new column names of \code{bp} to specify which axes should be labelled.}

\item{which}{a vector containing the new columns or variables for which the axes should be displayed, with default \code{1:num.vars}.}

\item{col}{the colour(s) for the axes, with default \code{grey(0.7)}. Alternatively, provide a vector of colours corresponding to \code{X.names}.}

\item{lwd}{the line width(s) for the axes, with default \code{1}.}

\item{lty}{the line type(s) for the axes, with default \code{1}.}

\item{label.dir}{a character string indicating the placement of the axis titles to the side of the figure. One of "\code{Orthog}" for axis titles to appear orthogonal to the side of the figure (default) , "\code{Hor}" for axis titles to appear horizontally or "\code{Paral}" for axis titles to appear parallel to the side of the figure.}

\item{label.col}{the colour(s) for the axis labels, with default, \code{col}.}

\item{label.cex}{the label expansion for the axis labels, with default \code{0.75}.}

\item{label.line}{the distance of the axis title from the side of the figure, with default \code{0.1}.}

\item{ticks}{an integer-valued vector indicating the number of tickmarks for each axis, with default \code{5} for each axis.}

\item{tick.col}{the colour(s) for the tick marks, with default \code{col}.}

\item{tick.size}{a vector specifying the sizes of tick marks for each axis, with default \code{1} for each .}

\item{tick.label}{a logical value indicating whether the axes should be labelled, with default \code{TRUE}.}

\item{tick.label.col}{the colour(s) for the tick mark labels, with default \code{tick.col}.}

\item{tick.label.cex}{the label expansion for the tick mark labels, with default \code{0.6}.}

\item{tick.label.side}{a character string indicating the position of the tick label. One of "\code{below}" for the label to appear below the tick mark (default) or "\code{above}" for the label to appear above the tick mark.}

\item{predict.col}{the colour(s) for the predicted samples, with default \code{col}.}

\item{predict.lwd}{the line width(s) for the predicted samples, with default \code{lwd}.}

\item{predict.lty}{the line type(s) for the predicted samples, with default \code{lty}.}

\item{ax.names}{a vector of size \code{p} containing user defined titles for the axes.}

\item{orthogx}{a numeric vector of size \code{p} specifying the x-coordinate of the parallel transformation of each axis, with default \code{0} for each axis. This is only used when \code{dim.biplot = 2}.}

\item{orthogy}{a numeric vector of size \code{p} specifying the y-coordinate of the parallel transformation of each axis, with default \code{0} for each axis. This is only used when \code{dim.biplot = 2}.}
}
\value{
The object of class \code{biplot} will be appended with a list called \code{newaxes} containing elements similar to that of \code{axes}.
}
\description{
This function allows the user to format the aesthetics for the supplementary (new) biplot axes.
}
\examples{
biplot(data = iris[,1:2]) |> PCA() |> interpolate(newvariable = iris[3:4]) |> 
  newaxes(col="gold") |> plot()
}
\seealso{
\code{\link{biplot}}, \code{\link{axes}}
}
