% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bf_decode.R
\name{bf_decode}
\alias{bf_decode}
\title{Decode (unpack) a bitfield}
\usage{
bf_decode(x, registry, flags = NULL, sep = NULL, verbose = TRUE)
}
\arguments{
\item{x}{\code{\link[=integer]{integerish(1)}}\cr table of the integer representation of
the bitfield.}

\item{registry}{\code{\link[=registry]{registry(1)}}\cr the registry that should be used
to decode the bitfield.}

\item{flags}{\code{\link[=character]{character(.)}}\cr the name(s) of flags to extract
from this bitfield; leave at \code{NULL} to extract the full bitfield.}

\item{sep}{\code{\link[=character]{character(1)}}\cr a symbol with which, if given, the
distinct fields shall be separated.}

\item{verbose}{\code{\link[=logical]{logical(1)}}\cr whether or not to return the
registry legend.}
}
\value{
data.frame with the binary values of flags in the registry in columns.
}
\description{
This function takes an integer bitfield and the registry used to build it
upstream to decode it into bit representation and thereby unpack the data
stored in the bitfield.
}
\examples{
# build registry
reg <- bf_map(protocol = "na", data = bf_tbl, x = commodity)
reg <- bf_map(protocol = "matches", data = bf_tbl, x = commodity, set = c("soybean", "maize"),
              registry = reg)
reg

# encode the flags into a bitfield
field <- bf_encode(registry = reg)
field

# decode (somewhere downstream)
flags <- bf_decode(x = field, registry = reg, sep = "-")
flags

# more reader friendly
cbind(bf_tbl, bf_decode(x = field, registry = reg, verbose = FALSE))
}
