// Generated by rstantools.  Do not edit by hand.

/*
    bmgarch is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    bmgarch is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with bmgarch.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.26.1-4-gd72b68b7-dirty
#include <stan/model/model_header.hpp>
namespace model_forecastCCC_namespace {
inline void validate_positive_index(const char* var_name, const char* expr,
                                    int val) {
  if (val < 1) {
    std::stringstream msg;
    msg << "Found dimension size less than one in simplex declaration"
        << "; variable=" << var_name << "; dimension size expression=" << expr
        << "; expression value=" << val;
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
inline void validate_unit_vector_index(const char* var_name, const char* expr,
                                       int val) {
  if (val <= 1) {
    std::stringstream msg;
    if (val == 1) {
      msg << "Found dimension size one in unit vector declaration."
          << " One-dimensional unit vector is discrete"
          << " but the target distribution must be continuous."
          << " variable=" << var_name << "; dimension size expression=" << expr;
    } else {
      msg << "Found dimension size less than one in unit vector declaration"
          << "; variable=" << var_name << "; dimension size expression=" << expr
          << "; expression value=" << val;
    }
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using std::pow;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::model_base_crtp;
using stan::model::rvalue;
using stan::model::cons_list;
using stan::model::index_uni;
using stan::model::index_max;
using stan::model::index_min;
using stan::model::index_min_max;
using stan::model::index_multi;
using stan::model::index_omni;
using stan::model::nil_index_list;
using namespace stan::math;
using stan::math::pow; 
stan::math::profile_map profiles__;
static int current_statement__= 0;
static const std::vector<string> locations_array__ = {" (found before start of program)",
                                                      " (in 'forecastCCC', line 42, column 0 to column 16)",
                                                      " (in 'forecastCCC', line 47, column 0 to column 41)",
                                                      " (in 'forecastCCC', line 48, column 0 to column 43)",
                                                      " (in 'forecastCCC', line 54, column 0 to column 16)",
                                                      " (in 'forecastCCC', line 56, column 2 to column 23)",
                                                      " (in 'forecastCCC', line 60, column 2 to column 17)",
                                                      " (in 'forecastCCC', line 61, column 2 to column 47)",
                                                      " (in 'forecastCCC', line 62, column 2 to column 47)",
                                                      " (in 'forecastCCC', line 64, column 2 to column 20)",
                                                      " (in 'forecastCCC', line 66, column 2 to column 32)",
                                                      " (in 'forecastCCC', line 67, column 2 to column 28)",
                                                      " (in 'forecastCCC', line 68, column 2 to column 27)",
                                                      " (in 'forecastCCC', line 69, column 2 to column 25)",
                                                      " (in 'forecastCCC', line 70, column 2 to column 24)",
                                                      " (in 'forecastCCC', line 74, column 2 to column 41)",
                                                      " (in 'forecastCCC', line 75, column 2 to column 81)",
                                                      " (in 'forecastCCC', line 76, column 2 to column 66)",
                                                      " (in 'forecastCCC', line 77, column 2 to column 45)",
                                                      " (in 'forecastCCC', line 78, column 2 to column 43)",
                                                      " (in 'forecastCCC', line 81, column 2 to column 42)",
                                                      " (in 'forecastCCC', line 82, column 2 to column 40)",
                                                      " (in 'forecastCCC', line 84, column 2 to column 43)",
                                                      " (in 'forecastCCC', line 85, column 2 to column 41)",
                                                      " (in 'forecastCCC', line 86, column 2 to column 42)",
                                                      " (in 'forecastCCC', line 89, column 2 to column 53)",
                                                      " (in 'forecastCCC', line 91, column 2 to column 31)",
                                                      " (in 'forecastCCC', line 92, column 2 to column 33)",
                                                      " (in 'forecastCCC', line 93, column 2 to column 33)",
                                                      " (in 'forecastCCC', line 96, column 2 to column 63)",
                                                      " (in 'forecastCCC', line 97, column 2 to column 63)",
                                                      " (in 'forecastCCC', line 98, column 2 to column 62)",
                                                      " (in 'forecastCCC', line 99, column 2 to column 60)",
                                                      " (in 'forecastCCC', line 100, column 2 to column 58)",
                                                      " (in 'forecastCCC', line 102, column 2 to column 53)",
                                                      " (in 'forecastCCC', line 103, column 2 to column 53)",
                                                      " (in 'forecastCCC', line 105, column 2 to column 58)",
                                                      " (in 'forecastCCC', line 106, column 2 to column 52)",
                                                      " (in 'forecastCCC', line 107, column 2 to column 50)",
                                                      " (in 'forecastCCC', line 115, column 6 to column 83)",
                                                      " (in 'forecastCCC', line 114, column 35 to line 116, column 5)",
                                                      " (in 'forecastCCC', line 114, column 11 to line 116, column 5)",
                                                      " (in 'forecastCCC', line 113, column 6 to column 23)",
                                                      " (in 'forecastCCC', line 112, column 28 to line 114, column 5)",
                                                      " (in 'forecastCCC', line 112, column 4 to line 116, column 5)",
                                                      " (in 'forecastCCC', line 120, column 6 to column 18)",
                                                      " (in 'forecastCCC', line 121, column 6 to column 20)",
                                                      " (in 'forecastCCC', line 122, column 6 to column 20)",
                                                      " (in 'forecastCCC', line 125, column 5 to column 59)",
                                                      " (in 'forecastCCC', line 126, column 5 to column 49)",
                                                      " (in 'forecastCCC', line 124, column 33 to line 127, column 7)",
                                                      " (in 'forecastCCC', line 124, column 6 to line 127, column 7)",
                                                      " (in 'forecastCCC', line 129, column 5 to column 49)",
                                                      " (in 'forecastCCC', line 128, column 33 to line 130, column 7)",
                                                      " (in 'forecastCCC', line 128, column 6 to line 130, column 7)",
                                                      " (in 'forecastCCC', line 134, column 7 to column 50)",
                                                      " (in 'forecastCCC', line 133, column 34 to line 135, column 7)",
                                                      " (in 'forecastCCC', line 133, column 13 to line 135, column 7)",
                                                      " (in 'forecastCCC', line 132, column 7 to column 72)",
                                                      " (in 'forecastCCC', line 131, column 27 to line 133, column 7)",
                                                      " (in 'forecastCCC', line 131, column 6 to line 135, column 7)",
                                                      " (in 'forecastCCC', line 136, column 6 to column 32)",
                                                      " (in 'forecastCCC', line 119, column 20 to line 137, column 5)",
                                                      " (in 'forecastCCC', line 119, column 4 to line 137, column 5)",
                                                      " (in 'forecastCCC', line 138, column 4 to column 41)",
                                                      " (in 'forecastCCC', line 144, column 2 to column 58)",
                                                      " (in 'forecastCCC', line 143, column 33 to line 145, column 2)",
                                                      " (in 'forecastCCC', line 143, column 8 to line 145, column 2)",
                                                      " (in 'forecastCCC', line 142, column 2 to column 51)",
                                                      " (in 'forecastCCC', line 141, column 25 to line 143, column 2)",
                                                      " (in 'forecastCCC', line 141, column 0 to line 145, column 2)",
                                                      " (in 'forecastCCC', line 110, column 52 to line 161, column 3)",
                                                      " (in 'forecastCCC', line 110, column 2 to line 161, column 3)",
                                                      " (in 'forecastCCC', line 162, column 2 to column 62)",
                                                      " (in 'forecastCCC', line 163, column 2 to column 58)",
                                                      " (in 'forecastCCC', line 165, column 2 to column 60)",
                                                      " (in 'forecastCCC', line 174, column 6 to column 96)",
                                                      " (in 'forecastCCC', line 173, column 22 to line 175, column 5)",
                                                      " (in 'forecastCCC', line 173, column 4 to line 175, column 5)",
                                                      " (in 'forecastCCC', line 172, column 33 to line 176, column 3)",
                                                      " (in 'forecastCCC', line 172, column 9 to line 176, column 3)",
                                                      " (in 'forecastCCC', line 170, column 6 to column 89)",
                                                      " (in 'forecastCCC', line 169, column 22 to line 171, column 5)",
                                                      " (in 'forecastCCC', line 169, column 4 to line 171, column 5)",
                                                      " (in 'forecastCCC', line 168, column 26 to line 172, column 3)",
                                                      " (in 'forecastCCC', line 168, column 2 to line 176, column 3)",
                                                      " (in 'forecastCCC', line 167, column 22 to line 177, column 2)",
                                                      " (in 'forecastCCC', line 167, column 0 to line 177, column 2)",
                                                      " (in 'forecastCCC', line 3, column 0 to column 15)",
                                                      " (in 'forecastCCC', line 4, column 0 to column 16)",
                                                      " (in 'forecastCCC', line 5, column 0 to column 15)",
                                                      " (in 'forecastCCC', line 6, column 0 to column 15)",
                                                      " (in 'forecastCCC', line 7, column 6 to column 7)",
                                                      " (in 'forecastCCC', line 7, column 16 to column 18)",
                                                      " (in 'forecastCCC', line 7, column 0 to column 24)",
                                                      " (in 'forecastCCC', line 8, column 6 to column 7)",
                                                      " (in 'forecastCCC', line 8, column 16 to column 18)",
                                                      " (in 'forecastCCC', line 8, column 0 to column 23)",
                                                      " (in 'forecastCCC', line 9, column 0 to column 35)",
                                                      " (in 'forecastCCC', line 10, column 0 to column 36)",
                                                      " (in 'forecastCCC', line 11, column 0 to column 19)",
                                                      " (in 'forecastCCC', line 12, column 6 to column 11)",
                                                      " (in 'forecastCCC', line 12, column 20 to column 22)",
                                                      " (in 'forecastCCC', line 12, column 0 to column 29)",
                                                      " (in 'forecastCCC', line 13, column 6 to column 11)",
                                                      " (in 'forecastCCC', line 13, column 20 to column 22)",
                                                      " (in 'forecastCCC', line 13, column 0 to column 35)",
                                                      " (in 'forecastCCC', line 14, column 0 to column 42)",
                                                      " (in 'forecastCCC', line 17, column 9 to column 25)",
                                                      " (in 'forecastCCC', line 17, column 27 to column 29)",
                                                      " (in 'forecastCCC', line 17, column 2 to column 36)",
                                                      " (in 'forecastCCC', line 20, column 6 to column 7)",
                                                      " (in 'forecastCCC', line 20, column 16 to column 18)",
                                                      " (in 'forecastCCC', line 20, column 20 to column 22)",
                                                      " (in 'forecastCCC', line 20, column 0 to column 29)",
                                                      " (in 'forecastCCC', line 21, column 0 to column 29)",
                                                      " (in 'forecastCCC', line 22, column 0 to column 19)",
                                                      " (in 'forecastCCC', line 25, column 2 to column 33)",
                                                      " (in 'forecastCCC', line 27, column 2 to column 33)",
                                                      " (in 'forecastCCC', line 29, column 4 to column 30)",
                                                      " (in 'forecastCCC', line 28, column 2 to line 29, column 30)",
                                                      " (in 'forecastCCC', line 24, column 15 to line 30, column 2)",
                                                      " (in 'forecastCCC', line 24, column 0 to line 30, column 2)",
                                                      " (in 'forecastCCC', line 33, column 4 to column 38)",
                                                      " (in 'forecastCCC', line 32, column 24 to line 34, column 3)",
                                                      " (in 'forecastCCC', line 32, column 2 to line 34, column 3)",
                                                      " (in 'forecastCCC', line 36, column 4 to column 34)",
                                                      " (in 'forecastCCC', line 35, column 20 to line 37, column 3)",
                                                      " (in 'forecastCCC', line 35, column 2 to line 37, column 3)",
                                                      " (in 'forecastCCC', line 42, column 7 to column 9)",
                                                      " (in 'forecastCCC', line 47, column 30 to column 32)",
                                                      " (in 'forecastCCC', line 47, column 33 to column 35)",
                                                      " (in 'forecastCCC', line 48, column 30 to column 32)",
                                                      " (in 'forecastCCC', line 48, column 33 to column 35)",
                                                      " (in 'forecastCCC', line 54, column 7 to column 9)",
                                                      " (in 'forecastCCC', line 60, column 9 to column 11)",
                                                      " (in 'forecastCCC', line 61, column 8 to column 9)",
                                                      " (in 'forecastCCC', line 61, column 39 to column 41)",
                                                      " (in 'forecastCCC', line 62, column 8 to column 9)",
                                                      " (in 'forecastCCC', line 62, column 39 to column 41)",
                                                      " (in 'forecastCCC', line 64, column 14 to column 16)",
                                                      " (in 'forecastCCC', line 66, column 20 to column 22)",
                                                      " (in 'forecastCCC', line 67, column 8 to column 9)",
                                                      " (in 'forecastCCC', line 67, column 22 to column 24)",
                                                      " (in 'forecastCCC', line 68, column 8 to column 11)",
                                                      " (in 'forecastCCC', line 68, column 20 to column 22)",
                                                      " (in 'forecastCCC', line 69, column 8 to column 9)",
                                                      " (in 'forecastCCC', line 69, column 18 to column 20)",
                                                      " (in 'forecastCCC', line 70, column 8 to column 9)",
                                                      " (in 'forecastCCC', line 70, column 18 to column 20)",
                                                      " (in 'forecastCCC', line 74, column 8 to column 24)",
                                                      " (in 'forecastCCC', line 74, column 33 to column 35)",
                                                      " (in 'forecastCCC', line 75, column 8 to column 25)",
                                                      " (in 'forecastCCC', line 75, column 39 to column 41)",
                                                      " (in 'forecastCCC', line 76, column 8 to column 13)",
                                                      " (in 'forecastCCC', line 76, column 27 to column 29)",
                                                      " (in 'forecastCCC', line 77, column 8 to column 24)",
                                                      " (in 'forecastCCC', line 77, column 37 to column 39)",
                                                      " (in 'forecastCCC', line 78, column 8 to column 13)",
                                                      " (in 'forecastCCC', line 78, column 26 to column 28)",
                                                      " (in 'forecastCCC', line 81, column 8 to column 24)",
                                                      " (in 'forecastCCC', line 81, column 33 to column 35)",
                                                      " (in 'forecastCCC', line 82, column 8 to column 13)",
                                                      " (in 'forecastCCC', line 82, column 22 to column 24)",
                                                      " (in 'forecastCCC', line 84, column 8 to column 24)",
                                                      " (in 'forecastCCC', line 84, column 33 to column 35)",
                                                      " (in 'forecastCCC', line 85, column 8 to column 13)",
                                                      " (in 'forecastCCC', line 85, column 22 to column 24)",
                                                      " (in 'forecastCCC', line 86, column 8 to column 24)",
                                                      " (in 'forecastCCC', line 86, column 33 to column 35)",
                                                      " (in 'forecastCCC', line 89, column 9 to column 38)",
                                                      " (in 'forecastCCC', line 91, column 8 to column 10)",
                                                      " (in 'forecastCCC', line 92, column 8 to column 10)",
                                                      " (in 'forecastCCC', line 93, column 8 to column 10)"};
#include <stan_meta_header.hpp>
class model_forecastCCC final : public model_base_crtp<model_forecastCCC> {
private:
  int T;
  int nt;
  int Q;
  int P;
  std::vector<Eigen::Matrix<double, -1, 1>> rts;
  std::vector<Eigen::Matrix<double, -1, 1>> xC;
  int distribution;
  int meanstructure;
  int ahead;
  std::vector<Eigen::Matrix<double, -1, 1>> xC_p;
  std::vector<Eigen::Matrix<double, -1, 1>> future_rts;
  int compute_log_lik;
  Eigen::Matrix<double, -1, -1> xC_c;
  std::vector<Eigen::Matrix<double, -1, -1>> xC_m;
  int xC_marker;
  double cp;
  int rr_1dim__;
  int D_p_1dim__;
  int R_p_1dim__;
  int H_p_1dim__;
  int mu_p_1dim__;
  int rts_p_1dim__;
  int rr_p_1dim__;
  int log_lik_1dim__;
 
public:
  ~model_forecastCCC() { }
  
  inline std::string model_name() const final { return "model_forecastCCC"; }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.26.1-4-gd72b68b7-dirty", "stancflags = "};
  }
  
  
  model_forecastCCC(stan::io::var_context& context__,
                    unsigned int random_seed__ = 0,
                    std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    using local_scalar_t__ = double ;
    boost::ecuyer1988 base_rng__ = 
        stan::services::util::create_rng(random_seed__, 0);
    (void) base_rng__;  // suppress unused var warning
    static const char* function__ = "model_forecastCCC_namespace::model_forecastCCC";
    (void) function__;  // suppress unused var warning
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      current_statement__ = 88;
      context__.validate_dims("data initialization","T","int",
          context__.to_vec());
      T = std::numeric_limits<int>::min();
      
      current_statement__ = 88;
      T = context__.vals_i("T")[(1 - 1)];
      current_statement__ = 88;
      current_statement__ = 88;
      check_greater_or_equal(function__, "T", T, 2);
      current_statement__ = 89;
      context__.validate_dims("data initialization","nt","int",
          context__.to_vec());
      nt = std::numeric_limits<int>::min();
      
      current_statement__ = 89;
      nt = context__.vals_i("nt")[(1 - 1)];
      current_statement__ = 89;
      current_statement__ = 89;
      check_greater_or_equal(function__, "nt", nt, 2);
      current_statement__ = 90;
      context__.validate_dims("data initialization","Q","int",
          context__.to_vec());
      Q = std::numeric_limits<int>::min();
      
      current_statement__ = 90;
      Q = context__.vals_i("Q")[(1 - 1)];
      current_statement__ = 90;
      current_statement__ = 90;
      check_greater_or_equal(function__, "Q", Q, 1);
      current_statement__ = 91;
      context__.validate_dims("data initialization","P","int",
          context__.to_vec());
      P = std::numeric_limits<int>::min();
      
      current_statement__ = 91;
      P = context__.vals_i("P")[(1 - 1)];
      current_statement__ = 91;
      current_statement__ = 91;
      check_greater_or_equal(function__, "P", P, 1);
      current_statement__ = 92;
      validate_non_negative_index("rts", "T", T);
      current_statement__ = 93;
      validate_non_negative_index("rts", "nt", nt);
      current_statement__ = 94;
      context__.validate_dims("data initialization","rts","double",
          context__.to_vec(T, nt));
      rts = std::vector<Eigen::Matrix<double, -1, 1>>(T, Eigen::Matrix<double, -1, 1>(nt));
      stan::math::fill(rts, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> rts_flat__;
        current_statement__ = 94;
        assign(rts_flat__, nil_index_list(), context__.vals_r("rts"),
          "assigning variable rts_flat__");
        current_statement__ = 94;
        pos__ = 1;
        current_statement__ = 94;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 94;
          for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
            current_statement__ = 94;
            assign(rts,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              rts_flat__[(pos__ - 1)], "assigning variable rts");
            current_statement__ = 94;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 95;
      validate_non_negative_index("xC", "T", T);
      current_statement__ = 96;
      validate_non_negative_index("xC", "nt", nt);
      current_statement__ = 97;
      context__.validate_dims("data initialization","xC","double",
          context__.to_vec(T, nt));
      xC = std::vector<Eigen::Matrix<double, -1, 1>>(T, Eigen::Matrix<double, -1, 1>(nt));
      stan::math::fill(xC, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> xC_flat__;
        current_statement__ = 97;
        assign(xC_flat__, nil_index_list(), context__.vals_r("xC"),
          "assigning variable xC_flat__");
        current_statement__ = 97;
        pos__ = 1;
        current_statement__ = 97;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 97;
          for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
            current_statement__ = 97;
            assign(xC,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              xC_flat__[(pos__ - 1)], "assigning variable xC");
            current_statement__ = 97;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 98;
      context__.validate_dims("data initialization","distribution","int",
          context__.to_vec());
      distribution = std::numeric_limits<int>::min();
      
      current_statement__ = 98;
      distribution = context__.vals_i("distribution")[(1 - 1)];
      current_statement__ = 98;
      current_statement__ = 98;
      check_greater_or_equal(function__, "distribution", distribution, 0);
      current_statement__ = 98;
      current_statement__ = 98;
      check_less_or_equal(function__, "distribution", distribution, 1);
      current_statement__ = 99;
      context__.validate_dims("data initialization","meanstructure","int",
          context__.to_vec());
      meanstructure = std::numeric_limits<int>::min();
      
      current_statement__ = 99;
      meanstructure = context__.vals_i("meanstructure")[(1 - 1)];
      current_statement__ = 99;
      current_statement__ = 99;
      check_greater_or_equal(function__, "meanstructure", meanstructure, 0);
      current_statement__ = 99;
      current_statement__ = 99;
      check_less_or_equal(function__, "meanstructure", meanstructure, 2);
      current_statement__ = 100;
      context__.validate_dims("data initialization","ahead","int",
          context__.to_vec());
      ahead = std::numeric_limits<int>::min();
      
      current_statement__ = 100;
      ahead = context__.vals_i("ahead")[(1 - 1)];
      current_statement__ = 100;
      current_statement__ = 100;
      check_greater_or_equal(function__, "ahead", ahead, 1);
      current_statement__ = 101;
      validate_non_negative_index("xC_p", "ahead", ahead);
      current_statement__ = 102;
      validate_non_negative_index("xC_p", "nt", nt);
      current_statement__ = 103;
      context__.validate_dims("data initialization","xC_p","double",
          context__.to_vec(ahead, nt));
      xC_p = std::vector<Eigen::Matrix<double, -1, 1>>(ahead, Eigen::Matrix<double, -1, 1>(nt));
      stan::math::fill(xC_p, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> xC_p_flat__;
        current_statement__ = 103;
        assign(xC_p_flat__, nil_index_list(), context__.vals_r("xC_p"),
          "assigning variable xC_p_flat__");
        current_statement__ = 103;
        pos__ = 1;
        current_statement__ = 103;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 103;
          for (int sym2__ = 1; sym2__ <= ahead; ++sym2__) {
            current_statement__ = 103;
            assign(xC_p,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              xC_p_flat__[(pos__ - 1)], "assigning variable xC_p");
            current_statement__ = 103;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 104;
      validate_non_negative_index("future_rts", "ahead", ahead);
      current_statement__ = 105;
      validate_non_negative_index("future_rts", "nt", nt);
      current_statement__ = 106;
      context__.validate_dims("data initialization","future_rts","double",
          context__.to_vec(ahead, nt));
      future_rts = std::vector<Eigen::Matrix<double, -1, 1>>(ahead, Eigen::Matrix<double, -1, 1>(nt));
      stan::math::fill(future_rts, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> future_rts_flat__;
        current_statement__ = 106;
        assign(future_rts_flat__, nil_index_list(),
          context__.vals_r("future_rts"),
          "assigning variable future_rts_flat__");
        current_statement__ = 106;
        pos__ = 1;
        current_statement__ = 106;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 106;
          for (int sym2__ = 1; sym2__ <= ahead; ++sym2__) {
            current_statement__ = 106;
            assign(future_rts,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              future_rts_flat__[(pos__ - 1)], "assigning variable future_rts");
            current_statement__ = 106;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 107;
      context__.validate_dims("data initialization","compute_log_lik","int",
          context__.to_vec());
      compute_log_lik = std::numeric_limits<int>::min();
      
      current_statement__ = 107;
      compute_log_lik = context__.vals_i("compute_log_lik")[(1 - 1)];
      current_statement__ = 107;
      current_statement__ = 107;
      check_greater_or_equal(function__, "compute_log_lik", compute_log_lik,
                             0);
      current_statement__ = 107;
      current_statement__ = 107;
      check_less_or_equal(function__, "compute_log_lik", compute_log_lik, 1);
      current_statement__ = 108;
      validate_non_negative_index("xC_c", "ahead + max(Q, P)",
                                  (ahead + std::max(Q, P)));
      current_statement__ = 109;
      validate_non_negative_index("xC_c", "nt", nt);
      current_statement__ = 110;
      xC_c = Eigen::Matrix<double, -1, -1>((ahead + std::max(Q, P)), nt);
      stan::math::fill(xC_c, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 111;
      validate_non_negative_index("xC_m", "T", T);
      current_statement__ = 112;
      validate_non_negative_index("xC_m", "nt", nt);
      current_statement__ = 113;
      validate_non_negative_index("xC_m", "nt", nt);
      current_statement__ = 114;
      xC_m = std::vector<Eigen::Matrix<double, -1, -1>>(T, Eigen::Matrix<double, -1, -1>(nt, nt));
      stan::math::fill(xC_m, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 115;
      xC_marker = std::numeric_limits<int>::min();
      
      current_statement__ = 115;
      xC_marker = 0;
      current_statement__ = 116;
      cp = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 122;
      for (int t = 1; t <= T; ++t) {
        current_statement__ = 117;
        assign(xC_m, cons_list(index_uni(t), nil_index_list()),
          diag_matrix(xC[(t - 1)]), "assigning variable xC_m");
        current_statement__ = 118;
        cp = sum(multiply(transpose(xC_m[(t - 1)]), xC_m[(t - 1)]));
        current_statement__ = 120;
        if (logical_neq(cp, 0)) {
          current_statement__ = 119;
          xC_marker = (xC_marker + 1);
        } }
      current_statement__ = 125;
      for (int i = 1; i <= std::max(Q, P); ++i) {
        current_statement__ = 123;
        assign(xC_c, cons_list(index_uni(i), nil_index_list()),
          transpose(xC[((T - (std::max(Q, P) - 1)) - 1)]),
          "assigning variable xC_c");}
      current_statement__ = 128;
      for (int i = 1; i <= ahead; ++i) {
        current_statement__ = 126;
        assign(xC_c,
          cons_list(index_uni((i + std::max(Q, P))), nil_index_list()),
          transpose(xC_p[(i - 1)]), "assigning variable xC_c");}
      current_statement__ = 115;
      current_statement__ = 115;
      check_greater_or_equal(function__, "xC_marker", xC_marker, 0);
      current_statement__ = 116;
      current_statement__ = 116;
      check_greater_or_equal(function__, "cp", cp, 0);
      current_statement__ = 129;
      validate_non_negative_index("phi0", "nt", nt);
      current_statement__ = 130;
      validate_non_negative_index("phi", "nt", nt);
      current_statement__ = 131;
      validate_non_negative_index("phi", "nt", nt);
      current_statement__ = 132;
      validate_non_negative_index("theta", "nt", nt);
      current_statement__ = 133;
      validate_non_negative_index("theta", "nt", nt);
      current_statement__ = 134;
      validate_non_negative_index("beta", "nt", nt);
      current_statement__ = 135;
      validate_non_negative_index("c_h", "nt", nt);
      current_statement__ = 136;
      validate_non_negative_index("a_h", "Q", Q);
      current_statement__ = 137;
      validate_non_negative_index("a_h", "nt", nt);
      current_statement__ = 138;
      validate_non_negative_index("b_h", "P", P);
      current_statement__ = 139;
      validate_non_negative_index("b_h", "nt", nt);
      current_statement__ = 140;
      validate_non_negative_index("R", "nt", nt);
      current_statement__ = 140;
      validate_non_negative_index("R", "nt", nt);
      current_statement__ = 141;
      validate_non_negative_index("D1_init", "nt", nt);
      current_statement__ = 142;
      validate_non_negative_index("H", "T", T);
      current_statement__ = 143;
      validate_non_negative_index("H", "nt", nt);
      current_statement__ = 143;
      validate_non_negative_index("H", "nt", nt);
      current_statement__ = 144;
      rr_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 144;
      rr_1dim__ = (T - 1);
      current_statement__ = 144;
      validate_non_negative_index("rr", "T - 1", rr_1dim__);
      current_statement__ = 145;
      validate_non_negative_index("rr", "nt", nt);
      current_statement__ = 146;
      validate_non_negative_index("mu", "T", T);
      current_statement__ = 147;
      validate_non_negative_index("mu", "nt", nt);
      current_statement__ = 148;
      validate_non_negative_index("D", "T", T);
      current_statement__ = 149;
      validate_non_negative_index("D", "nt", nt);
      current_statement__ = 150;
      D_p_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 150;
      D_p_1dim__ = (ahead + std::max(Q, P));
      current_statement__ = 150;
      validate_non_negative_index("D_p", "ahead + max(Q, P)", D_p_1dim__);
      current_statement__ = 151;
      validate_non_negative_index("D_p", "nt", nt);
      current_statement__ = 152;
      R_p_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 152;
      R_p_1dim__ = (ahead + std::max(Q, P));
      current_statement__ = 152;
      validate_non_negative_index("R_p", "ahead + max(Q, P)", R_p_1dim__);
      current_statement__ = 153;
      validate_non_negative_index("R_p", "nt", nt);
      current_statement__ = 153;
      validate_non_negative_index("R_p", "nt", nt);
      current_statement__ = 154;
      validate_non_negative_index("R_forecasted", "ahead", ahead);
      current_statement__ = 155;
      validate_non_negative_index("R_forecasted", "nt", nt);
      current_statement__ = 155;
      validate_non_negative_index("R_forecasted", "nt", nt);
      current_statement__ = 156;
      H_p_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 156;
      H_p_1dim__ = (ahead + std::max(Q, P));
      current_statement__ = 156;
      validate_non_negative_index("H_p", "ahead + max(Q, P)", H_p_1dim__);
      current_statement__ = 157;
      validate_non_negative_index("H_p", "nt", nt);
      current_statement__ = 157;
      validate_non_negative_index("H_p", "nt", nt);
      current_statement__ = 158;
      validate_non_negative_index("H_forecasted", "ahead", ahead);
      current_statement__ = 159;
      validate_non_negative_index("H_forecasted", "nt", nt);
      current_statement__ = 159;
      validate_non_negative_index("H_forecasted", "nt", nt);
      current_statement__ = 160;
      mu_p_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 160;
      mu_p_1dim__ = (ahead + std::max(Q, P));
      current_statement__ = 160;
      validate_non_negative_index("mu_p", "ahead + max(Q, P)", mu_p_1dim__);
      current_statement__ = 161;
      validate_non_negative_index("mu_p", "nt", nt);
      current_statement__ = 162;
      validate_non_negative_index("mu_forecasted", "ahead", ahead);
      current_statement__ = 163;
      validate_non_negative_index("mu_forecasted", "nt", nt);
      current_statement__ = 164;
      rts_p_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 164;
      rts_p_1dim__ = (ahead + std::max(Q, P));
      current_statement__ = 164;
      validate_non_negative_index("rts_p", "ahead + max(Q, P)", rts_p_1dim__);
      current_statement__ = 165;
      validate_non_negative_index("rts_p", "nt", nt);
      current_statement__ = 166;
      validate_non_negative_index("rts_forecasted", "ahead", ahead);
      current_statement__ = 167;
      validate_non_negative_index("rts_forecasted", "nt", nt);
      current_statement__ = 168;
      rr_p_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 168;
      rr_p_1dim__ = (ahead + std::max(Q, P));
      current_statement__ = 168;
      validate_non_negative_index("rr_p", "ahead + max(Q, P)", rr_p_1dim__);
      current_statement__ = 169;
      validate_non_negative_index("rr_p", "nt", nt);
      current_statement__ = 170;
      log_lik_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 170;
      log_lik_1dim__ = (logical_eq(compute_log_lik, 1) ? ahead : 0);
      current_statement__ = 170;
      validate_non_negative_index("log_lik",
                                  "compute_log_lik == 1 ? ahead : 0",
                                  log_lik_1dim__);
      current_statement__ = 171;
      validate_non_negative_index("vd", "nt", nt);
      current_statement__ = 172;
      validate_non_negative_index("ma_d", "nt", nt);
      current_statement__ = 173;
      validate_non_negative_index("ar_d", "nt", nt);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    num_params_r__ = 0U;
    
    try {
      num_params_r__ += nt;
      num_params_r__ += nt * nt;
      num_params_r__ += nt * nt;
      num_params_r__ += nt;
      num_params_r__ += 1;
      num_params_r__ += nt;
      num_params_r__ += Q * nt;
      num_params_r__ += P * nt;
      num_params_r__ += ((nt * (nt - 1)) / 2);
      num_params_r__ += nt;
      num_params_r__ += T * (nt + ((nt * (nt - 1)) / 2));
      num_params_r__ += rr_1dim__ * nt;
      num_params_r__ += T * nt;
      num_params_r__ += T * nt;
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI, stan::require_vector_like_t<VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR> log_prob_impl(VecR& params_r__,
                                                 VecI& params_i__,
                                                 std::ostream* pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    static const char* function__ = "model_forecastCCC_namespace::log_prob";
(void) function__;  // suppress unused var warning
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<local_scalar_t__, -1, 1> phi0;
      phi0 = Eigen::Matrix<local_scalar_t__, -1, 1>(nt);
      stan::math::fill(phi0, DUMMY_VAR__);
      
      current_statement__ = 1;
      phi0 = in__.vector(nt);
      Eigen::Matrix<local_scalar_t__, -1, -1> phi;
      phi = Eigen::Matrix<local_scalar_t__, -1, -1>(nt, nt);
      stan::math::fill(phi, DUMMY_VAR__);
      
      current_statement__ = 2;
      phi = in__.matrix(nt, nt);
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        current_statement__ = 2;
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          current_statement__ = 2;
          if (jacobian__) {
            current_statement__ = 2;
            assign(phi,
              cons_list(index_uni(sym1__),
                cons_list(index_uni(sym2__), nil_index_list())),
              stan::math::lub_constrain(
                rvalue(phi,
                  cons_list(index_uni(sym1__),
                    cons_list(index_uni(sym2__), nil_index_list())), "phi"),
                -1, 1, lp__), "assigning variable phi");
          } else {
            current_statement__ = 2;
            assign(phi,
              cons_list(index_uni(sym1__),
                cons_list(index_uni(sym2__), nil_index_list())),
              stan::math::lub_constrain(
                rvalue(phi,
                  cons_list(index_uni(sym1__),
                    cons_list(index_uni(sym2__), nil_index_list())), "phi"),
                -1, 1), "assigning variable phi");
          }}}
      Eigen::Matrix<local_scalar_t__, -1, -1> theta;
      theta = Eigen::Matrix<local_scalar_t__, -1, -1>(nt, nt);
      stan::math::fill(theta, DUMMY_VAR__);
      
      current_statement__ = 3;
      theta = in__.matrix(nt, nt);
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        current_statement__ = 3;
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          current_statement__ = 3;
          if (jacobian__) {
            current_statement__ = 3;
            assign(theta,
              cons_list(index_uni(sym1__),
                cons_list(index_uni(sym2__), nil_index_list())),
              stan::math::lub_constrain(
                rvalue(theta,
                  cons_list(index_uni(sym1__),
                    cons_list(index_uni(sym2__), nil_index_list())), "theta"),
                -1, 1, lp__), "assigning variable theta");
          } else {
            current_statement__ = 3;
            assign(theta,
              cons_list(index_uni(sym1__),
                cons_list(index_uni(sym2__), nil_index_list())),
              stan::math::lub_constrain(
                rvalue(theta,
                  cons_list(index_uni(sym1__),
                    cons_list(index_uni(sym2__), nil_index_list())), "theta"),
                -1, 1), "assigning variable theta");
          }}}
      Eigen::Matrix<local_scalar_t__, -1, 1> beta;
      beta = Eigen::Matrix<local_scalar_t__, -1, 1>(nt);
      stan::math::fill(beta, DUMMY_VAR__);
      
      current_statement__ = 4;
      beta = in__.vector(nt);
      local_scalar_t__ nu;
      nu = DUMMY_VAR__;
      
      current_statement__ = 5;
      nu = in__.scalar();
      current_statement__ = 5;
      if (jacobian__) {
        current_statement__ = 5;
        nu = stan::math::lb_constrain(nu, 2, lp__);
      } else {
        current_statement__ = 5;
        nu = stan::math::lb_constrain(nu, 2);
      }
      Eigen::Matrix<local_scalar_t__, -1, 1> c_h;
      c_h = Eigen::Matrix<local_scalar_t__, -1, 1>(nt);
      stan::math::fill(c_h, DUMMY_VAR__);
      
      current_statement__ = 6;
      c_h = in__.vector(nt);
      std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> a_h;
      a_h = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(Q, Eigen::Matrix<local_scalar_t__, -1, 1>(nt));
      stan::math::fill(a_h, DUMMY_VAR__);
      
      current_statement__ = 7;
      for (int sym1__ = 1; sym1__ <= Q; ++sym1__) {
        current_statement__ = 7;
        assign(a_h, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector(nt), "assigning variable a_h");}
      current_statement__ = 7;
      for (int sym1__ = 1; sym1__ <= Q; ++sym1__) {
        current_statement__ = 7;
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          current_statement__ = 7;
          if (jacobian__) {
            current_statement__ = 7;
            assign(a_h,
              cons_list(index_uni(sym1__),
                cons_list(index_uni(sym2__), nil_index_list())),
              stan::math::lub_constrain(a_h[(sym1__ - 1)][(sym2__ - 1)], 0,
                1, lp__), "assigning variable a_h");
          } else {
            current_statement__ = 7;
            assign(a_h,
              cons_list(index_uni(sym1__),
                cons_list(index_uni(sym2__), nil_index_list())),
              stan::math::lub_constrain(a_h[(sym1__ - 1)][(sym2__ - 1)], 0, 1),
              "assigning variable a_h");
          }}}
      std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> b_h;
      b_h = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(P, Eigen::Matrix<local_scalar_t__, -1, 1>(nt));
      stan::math::fill(b_h, DUMMY_VAR__);
      
      current_statement__ = 8;
      for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
        current_statement__ = 8;
        assign(b_h, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector(nt), "assigning variable b_h");}
      current_statement__ = 8;
      for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
        current_statement__ = 8;
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          current_statement__ = 8;
          if (jacobian__) {
            current_statement__ = 8;
            assign(b_h,
              cons_list(index_uni(sym1__),
                cons_list(index_uni(sym2__), nil_index_list())),
              stan::math::lub_constrain(b_h[(sym1__ - 1)][(sym2__ - 1)], 0,
                1, lp__), "assigning variable b_h");
          } else {
            current_statement__ = 8;
            assign(b_h,
              cons_list(index_uni(sym1__),
                cons_list(index_uni(sym2__), nil_index_list())),
              stan::math::lub_constrain(b_h[(sym1__ - 1)][(sym2__ - 1)], 0, 1),
              "assigning variable b_h");
          }}}
      Eigen::Matrix<local_scalar_t__, -1, -1> R;
      R = Eigen::Matrix<local_scalar_t__, -1, -1>(nt, nt);
      stan::math::fill(R, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> R_in__;
      R_in__ = Eigen::Matrix<local_scalar_t__, -1, 1>(((nt * (nt - 1)) / 2));
      stan::math::fill(R_in__, DUMMY_VAR__);
      
      current_statement__ = 9;
      R_in__ = in__.vector(((nt * (nt - 1)) / 2));
      current_statement__ = 9;
      if (jacobian__) {
        current_statement__ = 9;
        assign(R, nil_index_list(),
          stan::math::corr_matrix_constrain(R_in__, nt, lp__),
          "assigning variable R");
      } else {
        current_statement__ = 9;
        assign(R, nil_index_list(),
          stan::math::corr_matrix_constrain(R_in__, nt),
          "assigning variable R");
      }
      Eigen::Matrix<local_scalar_t__, -1, 1> D1_init;
      D1_init = Eigen::Matrix<local_scalar_t__, -1, 1>(nt);
      stan::math::fill(D1_init, DUMMY_VAR__);
      
      current_statement__ = 10;
      D1_init = in__.vector(nt);
      current_statement__ = 10;
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        current_statement__ = 10;
        if (jacobian__) {
          current_statement__ = 10;
          assign(D1_init, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(D1_init[(sym1__ - 1)], 0, lp__),
            "assigning variable D1_init");
        } else {
          current_statement__ = 10;
          assign(D1_init, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(D1_init[(sym1__ - 1)], 0),
            "assigning variable D1_init");
        }}
      std::vector<Eigen::Matrix<local_scalar_t__, -1, -1>> H;
      H = std::vector<Eigen::Matrix<local_scalar_t__, -1, -1>>(T, Eigen::Matrix<local_scalar_t__, -1, -1>(nt, nt));
      stan::math::fill(H, DUMMY_VAR__);
      
      std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> H_in__;
      H_in__ = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(T, Eigen::Matrix<local_scalar_t__, -1, 1>(
        (nt + ((nt * (nt - 1)) / 2))));
      stan::math::fill(H_in__, DUMMY_VAR__);
      
      current_statement__ = 11;
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        current_statement__ = 11;
        assign(H_in__, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector((nt + ((nt * (nt - 1)) / 2))),
          "assigning variable H_in__");}
      current_statement__ = 11;
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        current_statement__ = 11;
        if (jacobian__) {
          current_statement__ = 11;
          assign(H, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::cov_matrix_constrain(H_in__[(sym1__ - 1)], nt, lp__),
            "assigning variable H");
        } else {
          current_statement__ = 11;
          assign(H, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::cov_matrix_constrain(H_in__[(sym1__ - 1)], nt),
            "assigning variable H");
        }}
      std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> rr;
      rr = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(rr_1dim__, Eigen::Matrix<local_scalar_t__, -1, 1>(nt));
      stan::math::fill(rr, DUMMY_VAR__);
      
      current_statement__ = 12;
      for (int sym1__ = 1; sym1__ <= rr_1dim__; ++sym1__) {
        current_statement__ = 12;
        assign(rr, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector(nt), "assigning variable rr");}
      std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> mu;
      mu = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(T, Eigen::Matrix<local_scalar_t__, -1, 1>(nt));
      stan::math::fill(mu, DUMMY_VAR__);
      
      current_statement__ = 13;
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        current_statement__ = 13;
        assign(mu, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector(nt), "assigning variable mu");}
      std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> D;
      D = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(T, Eigen::Matrix<local_scalar_t__, -1, 1>(nt));
      stan::math::fill(D, DUMMY_VAR__);
      
      current_statement__ = 14;
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        current_statement__ = 14;
        assign(D, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector(nt), "assigning variable D");}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
    } // log_prob_impl() 
    
  template <typename RNG, typename VecR, typename VecI, typename VecVar, stan::require_vector_like_vt<std::is_floating_point, VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr, stan::require_std_vector_vt<std::is_floating_point, VecVar>* = nullptr>
  inline void write_array_impl(RNG& base_rng__, VecR& params_r__,
                               VecI& params_i__, VecVar& vars__,
                               const bool emit_transformed_parameters__ = true,
                               const bool emit_generated_quantities__ = true,
                               std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.resize(0);
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    static const char* function__ = "model_forecastCCC_namespace::write_array";
(void) function__;  // suppress unused var warning
    (void) function__;  // suppress unused var warning
    double lp__ = 0.0;
    (void) lp__;  // dummy to suppress unused var warning
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<double, -1, 1> phi0;
      phi0 = Eigen::Matrix<double, -1, 1>(nt);
      stan::math::fill(phi0, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      phi0 = in__.vector(nt);
      Eigen::Matrix<double, -1, -1> phi;
      phi = Eigen::Matrix<double, -1, -1>(nt, nt);
      stan::math::fill(phi, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      phi = in__.matrix(nt, nt);
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        current_statement__ = 2;
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          current_statement__ = 2;
          assign(phi,
            cons_list(index_uni(sym1__),
              cons_list(index_uni(sym2__), nil_index_list())),
            stan::math::lub_constrain(
              rvalue(phi,
                cons_list(index_uni(sym1__),
                  cons_list(index_uni(sym2__), nil_index_list())), "phi"),
              -1, 1), "assigning variable phi");}}
      Eigen::Matrix<double, -1, -1> theta;
      theta = Eigen::Matrix<double, -1, -1>(nt, nt);
      stan::math::fill(theta, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      theta = in__.matrix(nt, nt);
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        current_statement__ = 3;
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          current_statement__ = 3;
          assign(theta,
            cons_list(index_uni(sym1__),
              cons_list(index_uni(sym2__), nil_index_list())),
            stan::math::lub_constrain(
              rvalue(theta,
                cons_list(index_uni(sym1__),
                  cons_list(index_uni(sym2__), nil_index_list())), "theta"),
              -1, 1), "assigning variable theta");}}
      Eigen::Matrix<double, -1, 1> beta;
      beta = Eigen::Matrix<double, -1, 1>(nt);
      stan::math::fill(beta, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 4;
      beta = in__.vector(nt);
      double nu;
      nu = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 5;
      nu = in__.scalar();
      current_statement__ = 5;
      nu = stan::math::lb_constrain(nu, 2);
      Eigen::Matrix<double, -1, 1> c_h;
      c_h = Eigen::Matrix<double, -1, 1>(nt);
      stan::math::fill(c_h, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 6;
      c_h = in__.vector(nt);
      std::vector<Eigen::Matrix<double, -1, 1>> a_h;
      a_h = std::vector<Eigen::Matrix<double, -1, 1>>(Q, Eigen::Matrix<double, -1, 1>(nt));
      stan::math::fill(a_h, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 7;
      for (int sym1__ = 1; sym1__ <= Q; ++sym1__) {
        current_statement__ = 7;
        assign(a_h, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector(nt), "assigning variable a_h");}
      current_statement__ = 7;
      for (int sym1__ = 1; sym1__ <= Q; ++sym1__) {
        current_statement__ = 7;
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          current_statement__ = 7;
          assign(a_h,
            cons_list(index_uni(sym1__),
              cons_list(index_uni(sym2__), nil_index_list())),
            stan::math::lub_constrain(a_h[(sym1__ - 1)][(sym2__ - 1)], 0, 1),
            "assigning variable a_h");}}
      std::vector<Eigen::Matrix<double, -1, 1>> b_h;
      b_h = std::vector<Eigen::Matrix<double, -1, 1>>(P, Eigen::Matrix<double, -1, 1>(nt));
      stan::math::fill(b_h, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 8;
      for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
        current_statement__ = 8;
        assign(b_h, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector(nt), "assigning variable b_h");}
      current_statement__ = 8;
      for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
        current_statement__ = 8;
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          current_statement__ = 8;
          assign(b_h,
            cons_list(index_uni(sym1__),
              cons_list(index_uni(sym2__), nil_index_list())),
            stan::math::lub_constrain(b_h[(sym1__ - 1)][(sym2__ - 1)], 0, 1),
            "assigning variable b_h");}}
      Eigen::Matrix<double, -1, -1> R;
      R = Eigen::Matrix<double, -1, -1>(nt, nt);
      stan::math::fill(R, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<local_scalar_t__, -1, 1> R_in__;
      R_in__ = Eigen::Matrix<local_scalar_t__, -1, 1>(((nt * (nt - 1)) / 2));
      stan::math::fill(R_in__, DUMMY_VAR__);
      
      current_statement__ = 9;
      R_in__ = in__.vector(((nt * (nt - 1)) / 2));
      current_statement__ = 9;
      assign(R, nil_index_list(),
        stan::math::corr_matrix_constrain(R_in__, nt), "assigning variable R");
      Eigen::Matrix<double, -1, 1> D1_init;
      D1_init = Eigen::Matrix<double, -1, 1>(nt);
      stan::math::fill(D1_init, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 10;
      D1_init = in__.vector(nt);
      current_statement__ = 10;
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        current_statement__ = 10;
        assign(D1_init, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_constrain(D1_init[(sym1__ - 1)], 0),
          "assigning variable D1_init");}
      std::vector<Eigen::Matrix<double, -1, -1>> H;
      H = std::vector<Eigen::Matrix<double, -1, -1>>(T, Eigen::Matrix<double, -1, -1>(nt, nt));
      stan::math::fill(H, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> H_in__;
      H_in__ = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(T, Eigen::Matrix<local_scalar_t__, -1, 1>(
        (nt + ((nt * (nt - 1)) / 2))));
      stan::math::fill(H_in__, DUMMY_VAR__);
      
      current_statement__ = 11;
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        current_statement__ = 11;
        assign(H_in__, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector((nt + ((nt * (nt - 1)) / 2))),
          "assigning variable H_in__");}
      current_statement__ = 11;
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        current_statement__ = 11;
        assign(H, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::cov_matrix_constrain(H_in__[(sym1__ - 1)], nt),
          "assigning variable H");}
      std::vector<Eigen::Matrix<double, -1, 1>> rr;
      rr = std::vector<Eigen::Matrix<double, -1, 1>>(rr_1dim__, Eigen::Matrix<double, -1, 1>(nt));
      stan::math::fill(rr, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 12;
      for (int sym1__ = 1; sym1__ <= rr_1dim__; ++sym1__) {
        current_statement__ = 12;
        assign(rr, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector(nt), "assigning variable rr");}
      std::vector<Eigen::Matrix<double, -1, 1>> mu;
      mu = std::vector<Eigen::Matrix<double, -1, 1>>(T, Eigen::Matrix<double, -1, 1>(nt));
      stan::math::fill(mu, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 13;
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        current_statement__ = 13;
        assign(mu, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector(nt), "assigning variable mu");}
      std::vector<Eigen::Matrix<double, -1, 1>> D;
      D = std::vector<Eigen::Matrix<double, -1, 1>>(T, Eigen::Matrix<double, -1, 1>(nt));
      stan::math::fill(D, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 14;
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        current_statement__ = 14;
        assign(D, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector(nt), "assigning variable D");}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        vars__.emplace_back(phi0[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          vars__.emplace_back(
            rvalue(phi,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())), "phi"));}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          vars__.emplace_back(
            rvalue(theta,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())), "theta"));}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        vars__.emplace_back(beta[(sym1__ - 1)]);}
      vars__.emplace_back(nu);
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        vars__.emplace_back(c_h[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= Q; ++sym2__) {
          vars__.emplace_back(a_h[(sym2__ - 1)][(sym1__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
          vars__.emplace_back(b_h[(sym2__ - 1)][(sym1__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          vars__.emplace_back(
            rvalue(R,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())), "R"));}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        vars__.emplace_back(D1_init[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          for (int sym3__ = 1; sym3__ <= T; ++sym3__) {
            vars__.emplace_back(
              rvalue(H,
                cons_list(index_uni(sym3__),
                  cons_list(index_uni(sym2__),
                    cons_list(index_uni(sym1__), nil_index_list()))), "H"));}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= rr_1dim__; ++sym2__) {
          vars__.emplace_back(rr[(sym2__ - 1)][(sym1__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
          vars__.emplace_back(mu[(sym2__ - 1)][(sym1__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
          vars__.emplace_back(D[(sym2__ - 1)][(sym1__ - 1)]);}}
      if (logical_negation((primitive_value(emit_transformed_parameters__) ||
            primitive_value(emit_generated_quantities__)))) {
        return ;
      } 
      if (logical_negation(emit_generated_quantities__)) {
        return ;
      } 
      std::vector<Eigen::Matrix<double, -1, 1>> D_p;
      D_p = std::vector<Eigen::Matrix<double, -1, 1>>(D_p_1dim__, Eigen::Matrix<double, -1, 1>(nt));
      stan::math::fill(D_p, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<Eigen::Matrix<double, -1, -1>> R_p;
      R_p = std::vector<Eigen::Matrix<double, -1, -1>>(R_p_1dim__, Eigen::Matrix<double, -1, -1>(nt, nt));
      stan::math::fill(R_p, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 16;
      assign(R_p, nil_index_list(), rep_array(R, (ahead + std::max(Q, P))),
        "assigning variable R_p");
      std::vector<Eigen::Matrix<double, -1, -1>> R_forecasted;
      R_forecasted = std::vector<Eigen::Matrix<double, -1, -1>>(ahead, Eigen::Matrix<double, -1, -1>(nt, nt));
      stan::math::fill(R_forecasted, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 17;
      assign(R_forecasted, nil_index_list(), rep_array(R, ahead),
        "assigning variable R_forecasted");
      std::vector<Eigen::Matrix<double, -1, -1>> H_p;
      H_p = std::vector<Eigen::Matrix<double, -1, -1>>(H_p_1dim__, Eigen::Matrix<double, -1, -1>(nt, nt));
      stan::math::fill(H_p, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<Eigen::Matrix<double, -1, -1>> H_forecasted;
      H_forecasted = std::vector<Eigen::Matrix<double, -1, -1>>(ahead, Eigen::Matrix<double, -1, -1>(nt, nt));
      stan::math::fill(H_forecasted, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<Eigen::Matrix<double, -1, 1>> mu_p;
      mu_p = std::vector<Eigen::Matrix<double, -1, 1>>(mu_p_1dim__, Eigen::Matrix<double, -1, 1>(nt));
      stan::math::fill(mu_p, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<Eigen::Matrix<double, -1, 1>> mu_forecasted;
      mu_forecasted = std::vector<Eigen::Matrix<double, -1, 1>>(ahead, Eigen::Matrix<double, -1, 1>(nt));
      stan::math::fill(mu_forecasted, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<Eigen::Matrix<double, -1, 1>> rts_p;
      rts_p = std::vector<Eigen::Matrix<double, -1, 1>>(rts_p_1dim__, Eigen::Matrix<double, -1, 1>(nt));
      stan::math::fill(rts_p, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<Eigen::Matrix<double, -1, 1>> rts_forecasted;
      rts_forecasted = std::vector<Eigen::Matrix<double, -1, 1>>(ahead, Eigen::Matrix<double, -1, 1>(nt));
      stan::math::fill(rts_forecasted, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<Eigen::Matrix<double, -1, 1>> rr_p;
      rr_p = std::vector<Eigen::Matrix<double, -1, 1>>(rr_p_1dim__, Eigen::Matrix<double, -1, 1>(nt));
      stan::math::fill(rr_p, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<double> log_lik;
      log_lik = std::vector<double>(log_lik_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<double> vd;
      vd = std::vector<double>(nt, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<double> ma_d;
      ma_d = std::vector<double>(nt, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<double> ar_d;
      ar_d = std::vector<double>(nt, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 29;
      assign(mu_p,
        cons_list(index_min_max(1, (ahead + std::max(Q, P))),
          cons_list(index_omni(), nil_index_list())),
        rvalue(mu,
          cons_list(index_min_max(1, (ahead + std::max(Q, P))),
            cons_list(index_omni(), nil_index_list())), "mu"),
        "assigning variable mu_p");
      current_statement__ = 30;
      assign(rts_p,
        cons_list(index_min_max(1, (ahead + std::max(Q, P))),
          cons_list(index_omni(), nil_index_list())),
        rvalue(rts,
          cons_list(index_min_max(1, (ahead + std::max(Q, P))),
            cons_list(index_omni(), nil_index_list())), "rts"),
        "assigning variable rts_p");
      current_statement__ = 31;
      assign(rr_p,
        cons_list(index_min_max(1, (ahead + std::max(Q, P))),
          cons_list(index_omni(), nil_index_list())),
        rvalue(rr,
          cons_list(index_min_max(1, (ahead + std::max(Q, P))),
            cons_list(index_omni(), nil_index_list())), "rr"),
        "assigning variable rr_p");
      current_statement__ = 32;
      assign(D_p,
        cons_list(index_min_max(1, (ahead + std::max(Q, P))),
          cons_list(index_omni(), nil_index_list())),
        rvalue(D,
          cons_list(index_min_max(1, (ahead + std::max(Q, P))),
            cons_list(index_omni(), nil_index_list())), "D"),
        "assigning variable D_p");
      current_statement__ = 33;
      assign(H_p,
        cons_list(index_min_max(1, (ahead + std::max(Q, P))),
          cons_list(index_omni(), nil_index_list())),
        rvalue(H,
          cons_list(index_min_max(1, (ahead + std::max(Q, P))),
            cons_list(index_omni(), nil_index_list())), "H"),
        "assigning variable H_p");
      current_statement__ = 34;
      assign(mu_p,
        cons_list(index_min_max(1, std::max(Q, P)),
          cons_list(index_omni(), nil_index_list())),
        rvalue(mu,
          cons_list(index_min_max((T - (std::max(Q, P) - 1)), T),
            cons_list(index_omni(), nil_index_list())), "mu"),
        "assigning variable mu_p");
      current_statement__ = 35;
      assign(rts_p,
        cons_list(index_min_max(1, std::max(Q, P)),
          cons_list(index_omni(), nil_index_list())),
        rvalue(rts,
          cons_list(index_min_max((T - (std::max(Q, P) - 1)), T),
            cons_list(index_omni(), nil_index_list())), "rts"),
        "assigning variable rts_p");
      current_statement__ = 36;
      assign(rr_p,
        cons_list(index_min_max(1, std::max(Q, P)),
          cons_list(index_omni(), nil_index_list())),
        rvalue(rr,
          cons_list(index_min_max(((T - 1) - (std::max(Q, P) - 1)), (T - 1)),
            cons_list(index_omni(), nil_index_list())), "rr"),
        "assigning variable rr_p");
      current_statement__ = 37;
      assign(D_p,
        cons_list(index_min_max(1, std::max(Q, P)),
          cons_list(index_omni(), nil_index_list())),
        rvalue(D,
          cons_list(index_min_max((T - (std::max(Q, P) - 1)), T),
            cons_list(index_omni(), nil_index_list())), "D"),
        "assigning variable D_p");
      current_statement__ = 38;
      assign(H_p,
        cons_list(index_min_max(1, std::max(Q, P)),
          cons_list(index_omni(), nil_index_list())),
        rvalue(H,
          cons_list(index_min_max((T - (std::max(Q, P) - 1)), T),
            cons_list(index_omni(), nil_index_list())), "H"),
        "assigning variable H_p");
      current_statement__ = 72;
      for (int t = (std::max(Q, P) + 1); t <= (std::max(Q, P) + ahead); ++t) {
        current_statement__ = 44;
        if (logical_eq(meanstructure, 0)) {
          current_statement__ = 42;
          assign(mu_p,
            cons_list(index_uni(t),
              cons_list(index_omni(), nil_index_list())), phi0,
            "assigning variable mu_p");
        } else {
          current_statement__ = 41;
          if (logical_eq(meanstructure, 1)) {
            current_statement__ = 39;
            assign(mu_p,
              cons_list(index_uni(t),
                cons_list(index_omni(), nil_index_list())),
              add(
                add(phi0,
                  multiply(phi,
                    rvalue(rts_p,
                      cons_list(index_uni((t - 1)),
                        cons_list(index_omni(), nil_index_list())), "rts_p"))),
                multiply(theta,
                  subtract(
                    rvalue(rts_p,
                      cons_list(index_uni((t - 1)),
                        cons_list(index_omni(), nil_index_list())), "rts_p"),
                    stan::model::deep_copy(
                      rvalue(mu_p,
                        cons_list(index_uni((t - 1)),
                          cons_list(index_omni(), nil_index_list())), "mu_p"))))),
              "assigning variable mu_p");
          } 
        }
        current_statement__ = 63;
        for (int d = 1; d <= nt; ++d) {
          current_statement__ = 45;
          assign(vd, cons_list(index_uni(d), nil_index_list()), 0.0,
            "assigning variable vd");
          current_statement__ = 46;
          assign(ma_d, cons_list(index_uni(d), nil_index_list()), 0.0,
            "assigning variable ma_d");
          current_statement__ = 47;
          assign(ar_d, cons_list(index_uni(d), nil_index_list()), 0.0,
            "assigning variable ar_d");
          current_statement__ = 51;
          for (int q = 1; q <= std::min((t - 1), Q); ++q) {
            current_statement__ = 48;
            assign(rr_p,
              cons_list(index_uni((t - q)),
                cons_list(index_uni(d), nil_index_list())),
              square(
                (rts_p[((t - q) - 1)][(d - 1)] -
                  mu_p[((t - q) - 1)][(d - 1)])), "assigning variable rr_p");
            current_statement__ = 49;
            assign(ma_d, cons_list(index_uni(d), nil_index_list()),
              (ma_d[(d - 1)] +
                (a_h[(q - 1)][(d - 1)] * rr_p[((t - q) - 1)][(d - 1)])),
              "assigning variable ma_d");}
          current_statement__ = 54;
          for (int p = 1; p <= std::min((t - 1), P); ++p) {
            current_statement__ = 52;
            assign(ar_d, cons_list(index_uni(d), nil_index_list()),
              (ar_d[(d - 1)] +
                (b_h[(p - 1)][(d - 1)] * pow(D_p[((t - p) - 1)][(d - 1)], 2))),
              "assigning variable ar_d");}
          current_statement__ = 60;
          if (logical_gte(xC_marker, 1)) {
            current_statement__ = 58;
            assign(vd, cons_list(index_uni(d), nil_index_list()),
              ((stan::math::exp(
                  (c_h[(d - 1)] +
                    (beta[(d - 1)] *
                      rvalue(xC_c,
                        cons_list(index_uni(t),
                          cons_list(index_uni(d), nil_index_list())), "xC_c"))))
                 + ma_d[(d - 1)]) + ar_d[(d - 1)]), "assigning variable vd");
          } else {
            current_statement__ = 57;
            if (logical_eq(xC_marker, 0)) {
              current_statement__ = 55;
              assign(vd, cons_list(index_uni(d), nil_index_list()),
                ((stan::math::exp(c_h[(d - 1)]) + ma_d[(d - 1)]) +
                  ar_d[(d - 1)]), "assigning variable vd");
            } 
          }
          current_statement__ = 61;
          assign(D_p,
            cons_list(index_uni(t),
              cons_list(index_uni(d), nil_index_list())),
            stan::math::sqrt(vd[(d - 1)]), "assigning variable D_p");}
        current_statement__ = 64;
        assign(H_p,
          cons_list(index_uni(t), cons_list(index_omni(), nil_index_list())),
          quad_form_diag(R,
            rvalue(D_p,
              cons_list(index_uni(t),
                cons_list(index_omni(), nil_index_list())), "D_p")),
          "assigning variable H_p");
        current_statement__ = 70;
        if (logical_eq(distribution, 0)) {
          current_statement__ = 68;
          assign(rts_p,
            cons_list(index_uni(t),
              cons_list(index_omni(), nil_index_list())),
            multi_normal_rng(
              rvalue(mu_p,
                cons_list(index_uni(t),
                  cons_list(index_omni(), nil_index_list())), "mu_p"),
              rvalue(H_p,
                cons_list(index_uni(t),
                  cons_list(index_omni(), nil_index_list())), "H_p"),
              base_rng__), "assigning variable rts_p");
        } else {
          current_statement__ = 67;
          if (logical_eq(distribution, 1)) {
            current_statement__ = 65;
            assign(rts_p,
              cons_list(index_uni(t),
                cons_list(index_omni(), nil_index_list())),
              multi_student_t_rng(nu,
                rvalue(mu_p,
                  cons_list(index_uni(t),
                    cons_list(index_omni(), nil_index_list())), "mu_p"),
                rvalue(H_p,
                  cons_list(index_uni(t),
                    cons_list(index_omni(), nil_index_list())), "H_p"),
                base_rng__), "assigning variable rts_p");
          } 
        }}
      current_statement__ = 73;
      assign(rts_forecasted, nil_index_list(),
        rvalue(rts_p,
          cons_list(
            index_min_max((std::max(Q, P) + 1), (std::max(Q, P) + ahead)),
            nil_index_list()), "rts_p"), "assigning variable rts_forecasted");
      current_statement__ = 74;
      assign(H_forecasted, nil_index_list(),
        rvalue(H_p,
          cons_list(
            index_min_max((std::max(Q, P) + 1), (std::max(Q, P) + ahead)),
            nil_index_list()), "H_p"), "assigning variable H_forecasted");
      current_statement__ = 75;
      assign(mu_forecasted, nil_index_list(),
        rvalue(mu_p,
          cons_list(
            index_min_max((std::max(Q, P) + 1), (std::max(Q, P) + ahead)),
            nil_index_list()), "mu_p"), "assigning variable mu_forecasted");
      current_statement__ = 87;
      if (compute_log_lik) {
        current_statement__ = 85;
        if (logical_eq(distribution, 0)) {
          current_statement__ = 83;
          for (int i = 1; i <= ahead; ++i) {
            current_statement__ = 81;
            assign(log_lik, cons_list(index_uni(i), nil_index_list()),
              multi_normal_lpdf<false>(future_rts[(i - 1)],
                mu_forecasted[(i - 1)], H_forecasted[(i - 1)]),
              "assigning variable log_lik");}
        } else {
          current_statement__ = 80;
          if (logical_eq(distribution, 1)) {
            current_statement__ = 78;
            for (int i = 1; i <= ahead; ++i) {
              current_statement__ = 76;
              assign(log_lik, cons_list(index_uni(i), nil_index_list()),
                multi_student_t_lpdf<false>(future_rts[(i - 1)], nu,
                  mu_forecasted[(i - 1)], H_forecasted[(i - 1)]),
                "assigning variable log_lik");}
          } 
        }
      } 
      current_statement__ = 16;
      for (int sym1__ = 1; sym1__ <= R_p_1dim__; ++sym1__) {
        current_statement__ = 16;
        current_statement__ = 16;
        check_corr_matrix(function__, "R_p[sym1__]", R_p[(sym1__ - 1)]);}
      current_statement__ = 17;
      for (int sym1__ = 1; sym1__ <= ahead; ++sym1__) {
        current_statement__ = 17;
        current_statement__ = 17;
        check_corr_matrix(function__, "R_forecasted[sym1__]",
                          R_forecasted[(sym1__ - 1)]);}
      current_statement__ = 18;
      for (int sym1__ = 1; sym1__ <= H_p_1dim__; ++sym1__) {
        current_statement__ = 18;
        current_statement__ = 18;
        check_cov_matrix(function__, "H_p[sym1__]", H_p[(sym1__ - 1)]);}
      current_statement__ = 19;
      for (int sym1__ = 1; sym1__ <= ahead; ++sym1__) {
        current_statement__ = 19;
        current_statement__ = 19;
        check_cov_matrix(function__, "H_forecasted[sym1__]",
                         H_forecasted[(sym1__ - 1)]);}
      current_statement__ = 26;
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        current_statement__ = 26;
        current_statement__ = 26;
        check_greater_or_equal(function__, "vd[sym1__]", vd[(sym1__ - 1)], 0);
      }
      current_statement__ = 27;
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        current_statement__ = 27;
        current_statement__ = 27;
        check_greater_or_equal(function__, "ma_d[sym1__]",
                               ma_d[(sym1__ - 1)], 0);}
      current_statement__ = 28;
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        current_statement__ = 28;
        current_statement__ = 28;
        check_greater_or_equal(function__, "ar_d[sym1__]",
                               ar_d[(sym1__ - 1)], 0);}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= D_p_1dim__; ++sym2__) {
          vars__.emplace_back(D_p[(sym2__ - 1)][(sym1__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          for (int sym3__ = 1; sym3__ <= R_p_1dim__; ++sym3__) {
            vars__.emplace_back(
              rvalue(R_p,
                cons_list(index_uni(sym3__),
                  cons_list(index_uni(sym2__),
                    cons_list(index_uni(sym1__), nil_index_list()))), "R_p"));
          }}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          for (int sym3__ = 1; sym3__ <= ahead; ++sym3__) {
            vars__.emplace_back(
              rvalue(R_forecasted,
                cons_list(index_uni(sym3__),
                  cons_list(index_uni(sym2__),
                    cons_list(index_uni(sym1__), nil_index_list()))),
                "R_forecasted"));}}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          for (int sym3__ = 1; sym3__ <= H_p_1dim__; ++sym3__) {
            vars__.emplace_back(
              rvalue(H_p,
                cons_list(index_uni(sym3__),
                  cons_list(index_uni(sym2__),
                    cons_list(index_uni(sym1__), nil_index_list()))), "H_p"));
          }}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          for (int sym3__ = 1; sym3__ <= ahead; ++sym3__) {
            vars__.emplace_back(
              rvalue(H_forecasted,
                cons_list(index_uni(sym3__),
                  cons_list(index_uni(sym2__),
                    cons_list(index_uni(sym1__), nil_index_list()))),
                "H_forecasted"));}}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= mu_p_1dim__; ++sym2__) {
          vars__.emplace_back(mu_p[(sym2__ - 1)][(sym1__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= ahead; ++sym2__) {
          vars__.emplace_back(mu_forecasted[(sym2__ - 1)][(sym1__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= rts_p_1dim__; ++sym2__) {
          vars__.emplace_back(rts_p[(sym2__ - 1)][(sym1__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= ahead; ++sym2__) {
          vars__.emplace_back(rts_forecasted[(sym2__ - 1)][(sym1__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= rr_p_1dim__; ++sym2__) {
          vars__.emplace_back(rr_p[(sym2__ - 1)][(sym1__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= log_lik_1dim__; ++sym1__) {
        vars__.emplace_back(log_lik[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        vars__.emplace_back(vd[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        vars__.emplace_back(ma_d[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        vars__.emplace_back(ar_d[(sym1__ - 1)]);}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // write_array_impl() 
    
  template <typename VecVar, typename VecI, stan::require_std_vector_t<VecVar>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void transform_inits_impl(const stan::io::var_context& context__,
                                   VecI& params_i__, VecVar& vars__,
                                   std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.clear();
    vars__.reserve(num_params_r__);
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      Eigen::Matrix<double, -1, 1> phi0;
      phi0 = Eigen::Matrix<double, -1, 1>(nt);
      stan::math::fill(phi0, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> phi0_flat__;
        current_statement__ = 1;
        assign(phi0_flat__, nil_index_list(), context__.vals_r("phi0"),
          "assigning variable phi0_flat__");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 1;
          assign(phi0, cons_list(index_uni(sym1__), nil_index_list()),
            phi0_flat__[(pos__ - 1)], "assigning variable phi0");
          current_statement__ = 1;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, -1> phi;
      phi = Eigen::Matrix<double, -1, -1>(nt, nt);
      stan::math::fill(phi, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> phi_flat__;
        current_statement__ = 2;
        assign(phi_flat__, nil_index_list(), context__.vals_r("phi"),
          "assigning variable phi_flat__");
        current_statement__ = 2;
        pos__ = 1;
        current_statement__ = 2;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 2;
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            current_statement__ = 2;
            assign(phi,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              phi_flat__[(pos__ - 1)], "assigning variable phi");
            current_statement__ = 2;
            pos__ = (pos__ + 1);}}
      }
      Eigen::Matrix<double, -1, -1> phi_free__;
      phi_free__ = Eigen::Matrix<double, -1, -1>(nt, nt);
      stan::math::fill(phi_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        current_statement__ = 2;
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          current_statement__ = 2;
          assign(phi_free__,
            cons_list(index_uni(sym1__),
              cons_list(index_uni(sym2__), nil_index_list())),
            stan::math::lub_free(
              rvalue(phi,
                cons_list(index_uni(sym1__),
                  cons_list(index_uni(sym2__), nil_index_list())), "phi"),
              -1, 1), "assigning variable phi_free__");}}
      Eigen::Matrix<double, -1, -1> theta;
      theta = Eigen::Matrix<double, -1, -1>(nt, nt);
      stan::math::fill(theta, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> theta_flat__;
        current_statement__ = 3;
        assign(theta_flat__, nil_index_list(), context__.vals_r("theta"),
          "assigning variable theta_flat__");
        current_statement__ = 3;
        pos__ = 1;
        current_statement__ = 3;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 3;
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            current_statement__ = 3;
            assign(theta,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              theta_flat__[(pos__ - 1)], "assigning variable theta");
            current_statement__ = 3;
            pos__ = (pos__ + 1);}}
      }
      Eigen::Matrix<double, -1, -1> theta_free__;
      theta_free__ = Eigen::Matrix<double, -1, -1>(nt, nt);
      stan::math::fill(theta_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        current_statement__ = 3;
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          current_statement__ = 3;
          assign(theta_free__,
            cons_list(index_uni(sym1__),
              cons_list(index_uni(sym2__), nil_index_list())),
            stan::math::lub_free(
              rvalue(theta,
                cons_list(index_uni(sym1__),
                  cons_list(index_uni(sym2__), nil_index_list())), "theta"),
              -1, 1), "assigning variable theta_free__");}}
      Eigen::Matrix<double, -1, 1> beta;
      beta = Eigen::Matrix<double, -1, 1>(nt);
      stan::math::fill(beta, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> beta_flat__;
        current_statement__ = 4;
        assign(beta_flat__, nil_index_list(), context__.vals_r("beta"),
          "assigning variable beta_flat__");
        current_statement__ = 4;
        pos__ = 1;
        current_statement__ = 4;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 4;
          assign(beta, cons_list(index_uni(sym1__), nil_index_list()),
            beta_flat__[(pos__ - 1)], "assigning variable beta");
          current_statement__ = 4;
          pos__ = (pos__ + 1);}
      }
      double nu;
      nu = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 5;
      nu = context__.vals_r("nu")[(1 - 1)];
      double nu_free__;
      nu_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 5;
      nu_free__ = stan::math::lb_free(nu, 2);
      Eigen::Matrix<double, -1, 1> c_h;
      c_h = Eigen::Matrix<double, -1, 1>(nt);
      stan::math::fill(c_h, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> c_h_flat__;
        current_statement__ = 6;
        assign(c_h_flat__, nil_index_list(), context__.vals_r("c_h"),
          "assigning variable c_h_flat__");
        current_statement__ = 6;
        pos__ = 1;
        current_statement__ = 6;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 6;
          assign(c_h, cons_list(index_uni(sym1__), nil_index_list()),
            c_h_flat__[(pos__ - 1)], "assigning variable c_h");
          current_statement__ = 6;
          pos__ = (pos__ + 1);}
      }
      std::vector<Eigen::Matrix<double, -1, 1>> a_h;
      a_h = std::vector<Eigen::Matrix<double, -1, 1>>(Q, Eigen::Matrix<double, -1, 1>(nt));
      stan::math::fill(a_h, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> a_h_flat__;
        current_statement__ = 7;
        assign(a_h_flat__, nil_index_list(), context__.vals_r("a_h"),
          "assigning variable a_h_flat__");
        current_statement__ = 7;
        pos__ = 1;
        current_statement__ = 7;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 7;
          for (int sym2__ = 1; sym2__ <= Q; ++sym2__) {
            current_statement__ = 7;
            assign(a_h,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              a_h_flat__[(pos__ - 1)], "assigning variable a_h");
            current_statement__ = 7;
            pos__ = (pos__ + 1);}}
      }
      std::vector<Eigen::Matrix<double, -1, 1>> a_h_free__;
      a_h_free__ = std::vector<Eigen::Matrix<double, -1, 1>>(Q, Eigen::Matrix<double, -1, 1>(nt));
      stan::math::fill(a_h_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 7;
      for (int sym1__ = 1; sym1__ <= Q; ++sym1__) {
        current_statement__ = 7;
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          current_statement__ = 7;
          assign(a_h_free__,
            cons_list(index_uni(sym1__),
              cons_list(index_uni(sym2__), nil_index_list())),
            stan::math::lub_free(a_h[(sym1__ - 1)][(sym2__ - 1)], 0, 1),
            "assigning variable a_h_free__");}}
      std::vector<Eigen::Matrix<double, -1, 1>> b_h;
      b_h = std::vector<Eigen::Matrix<double, -1, 1>>(P, Eigen::Matrix<double, -1, 1>(nt));
      stan::math::fill(b_h, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> b_h_flat__;
        current_statement__ = 8;
        assign(b_h_flat__, nil_index_list(), context__.vals_r("b_h"),
          "assigning variable b_h_flat__");
        current_statement__ = 8;
        pos__ = 1;
        current_statement__ = 8;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 8;
          for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
            current_statement__ = 8;
            assign(b_h,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              b_h_flat__[(pos__ - 1)], "assigning variable b_h");
            current_statement__ = 8;
            pos__ = (pos__ + 1);}}
      }
      std::vector<Eigen::Matrix<double, -1, 1>> b_h_free__;
      b_h_free__ = std::vector<Eigen::Matrix<double, -1, 1>>(P, Eigen::Matrix<double, -1, 1>(nt));
      stan::math::fill(b_h_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 8;
      for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
        current_statement__ = 8;
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          current_statement__ = 8;
          assign(b_h_free__,
            cons_list(index_uni(sym1__),
              cons_list(index_uni(sym2__), nil_index_list())),
            stan::math::lub_free(b_h[(sym1__ - 1)][(sym2__ - 1)], 0, 1),
            "assigning variable b_h_free__");}}
      Eigen::Matrix<double, -1, -1> R;
      R = Eigen::Matrix<double, -1, -1>(nt, nt);
      stan::math::fill(R, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> R_flat__;
        current_statement__ = 9;
        assign(R_flat__, nil_index_list(), context__.vals_r("R"),
          "assigning variable R_flat__");
        current_statement__ = 9;
        pos__ = 1;
        current_statement__ = 9;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 9;
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            current_statement__ = 9;
            assign(R,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              R_flat__[(pos__ - 1)], "assigning variable R");
            current_statement__ = 9;
            pos__ = (pos__ + 1);}}
      }
      Eigen::Matrix<double, -1, 1> R_free__;
      R_free__ = Eigen::Matrix<double, -1, 1>(((nt * (nt - 1)) / 2));
      stan::math::fill(R_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 9;
      assign(R_free__, nil_index_list(), stan::math::corr_matrix_free(R),
        "assigning variable R_free__");
      Eigen::Matrix<double, -1, 1> D1_init;
      D1_init = Eigen::Matrix<double, -1, 1>(nt);
      stan::math::fill(D1_init, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> D1_init_flat__;
        current_statement__ = 10;
        assign(D1_init_flat__, nil_index_list(), context__.vals_r("D1_init"),
          "assigning variable D1_init_flat__");
        current_statement__ = 10;
        pos__ = 1;
        current_statement__ = 10;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 10;
          assign(D1_init, cons_list(index_uni(sym1__), nil_index_list()),
            D1_init_flat__[(pos__ - 1)], "assigning variable D1_init");
          current_statement__ = 10;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> D1_init_free__;
      D1_init_free__ = Eigen::Matrix<double, -1, 1>(nt);
      stan::math::fill(D1_init_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 10;
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        current_statement__ = 10;
        assign(D1_init_free__,
          cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_free(D1_init[(sym1__ - 1)], 0),
          "assigning variable D1_init_free__");}
      std::vector<Eigen::Matrix<double, -1, -1>> H;
      H = std::vector<Eigen::Matrix<double, -1, -1>>(T, Eigen::Matrix<double, -1, -1>(nt, nt));
      stan::math::fill(H, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> H_flat__;
        current_statement__ = 11;
        assign(H_flat__, nil_index_list(), context__.vals_r("H"),
          "assigning variable H_flat__");
        current_statement__ = 11;
        pos__ = 1;
        current_statement__ = 11;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 11;
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            current_statement__ = 11;
            for (int sym3__ = 1; sym3__ <= T; ++sym3__) {
              current_statement__ = 11;
              assign(H,
                cons_list(index_uni(sym3__),
                  cons_list(index_uni(sym2__),
                    cons_list(index_uni(sym1__), nil_index_list()))),
                H_flat__[(pos__ - 1)], "assigning variable H");
              current_statement__ = 11;
              pos__ = (pos__ + 1);}}}
      }
      std::vector<Eigen::Matrix<double, -1, 1>> H_free__;
      H_free__ = std::vector<Eigen::Matrix<double, -1, 1>>(T, Eigen::Matrix<double, -1, 1>(
        (nt + ((nt * (nt - 1)) / 2))));
      stan::math::fill(H_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 11;
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        current_statement__ = 11;
        assign(H_free__, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::cov_matrix_free(H[(sym1__ - 1)]),
          "assigning variable H_free__");}
      std::vector<Eigen::Matrix<double, -1, 1>> rr;
      rr = std::vector<Eigen::Matrix<double, -1, 1>>(rr_1dim__, Eigen::Matrix<double, -1, 1>(nt));
      stan::math::fill(rr, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> rr_flat__;
        current_statement__ = 12;
        assign(rr_flat__, nil_index_list(), context__.vals_r("rr"),
          "assigning variable rr_flat__");
        current_statement__ = 12;
        pos__ = 1;
        current_statement__ = 12;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 12;
          for (int sym2__ = 1; sym2__ <= rr_1dim__; ++sym2__) {
            current_statement__ = 12;
            assign(rr,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              rr_flat__[(pos__ - 1)], "assigning variable rr");
            current_statement__ = 12;
            pos__ = (pos__ + 1);}}
      }
      std::vector<Eigen::Matrix<double, -1, 1>> mu;
      mu = std::vector<Eigen::Matrix<double, -1, 1>>(T, Eigen::Matrix<double, -1, 1>(nt));
      stan::math::fill(mu, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> mu_flat__;
        current_statement__ = 13;
        assign(mu_flat__, nil_index_list(), context__.vals_r("mu"),
          "assigning variable mu_flat__");
        current_statement__ = 13;
        pos__ = 1;
        current_statement__ = 13;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 13;
          for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
            current_statement__ = 13;
            assign(mu,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              mu_flat__[(pos__ - 1)], "assigning variable mu");
            current_statement__ = 13;
            pos__ = (pos__ + 1);}}
      }
      std::vector<Eigen::Matrix<double, -1, 1>> D;
      D = std::vector<Eigen::Matrix<double, -1, 1>>(T, Eigen::Matrix<double, -1, 1>(nt));
      stan::math::fill(D, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> D_flat__;
        current_statement__ = 14;
        assign(D_flat__, nil_index_list(), context__.vals_r("D"),
          "assigning variable D_flat__");
        current_statement__ = 14;
        pos__ = 1;
        current_statement__ = 14;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 14;
          for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
            current_statement__ = 14;
            assign(D,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              D_flat__[(pos__ - 1)], "assigning variable D");
            current_statement__ = 14;
            pos__ = (pos__ + 1);}}
      }
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        vars__.emplace_back(phi0[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          vars__.emplace_back(
            rvalue(phi_free__,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              "phi_free__"));}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          vars__.emplace_back(
            rvalue(theta_free__,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              "theta_free__"));}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        vars__.emplace_back(beta[(sym1__ - 1)]);}
      vars__.emplace_back(nu_free__);
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        vars__.emplace_back(c_h[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= Q; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          vars__.emplace_back(a_h_free__[(sym1__ - 1)][(sym2__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          vars__.emplace_back(b_h_free__[(sym1__ - 1)][(sym2__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= ((nt * (nt - 1)) / 2); ++sym1__) {
        vars__.emplace_back(R_free__[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        vars__.emplace_back(D1_init_free__[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= (nt + ((nt * (nt - 1)) / 2)); ++sym2__) {
          vars__.emplace_back(H_free__[(sym1__ - 1)][(sym2__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= rr_1dim__; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          vars__.emplace_back(rr[(sym1__ - 1)][(sym2__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          vars__.emplace_back(mu[(sym1__ - 1)][(sym2__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          vars__.emplace_back(D[(sym1__ - 1)][(sym2__ - 1)]);}}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // transform_inits_impl() 
    
  inline void get_param_names(std::vector<std::string>& names__) const {
    
    names__.clear();
    names__.emplace_back("phi0");
    names__.emplace_back("phi");
    names__.emplace_back("theta");
    names__.emplace_back("beta");
    names__.emplace_back("nu");
    names__.emplace_back("c_h");
    names__.emplace_back("a_h");
    names__.emplace_back("b_h");
    names__.emplace_back("R");
    names__.emplace_back("D1_init");
    names__.emplace_back("H");
    names__.emplace_back("rr");
    names__.emplace_back("mu");
    names__.emplace_back("D");
    names__.emplace_back("D_p");
    names__.emplace_back("R_p");
    names__.emplace_back("R_forecasted");
    names__.emplace_back("H_p");
    names__.emplace_back("H_forecasted");
    names__.emplace_back("mu_p");
    names__.emplace_back("mu_forecasted");
    names__.emplace_back("rts_p");
    names__.emplace_back("rts_forecasted");
    names__.emplace_back("rr_p");
    names__.emplace_back("log_lik");
    names__.emplace_back("vd");
    names__.emplace_back("ma_d");
    names__.emplace_back("ar_d");
    } // get_param_names() 
    
  inline void get_dims(std::vector<std::vector<size_t>>& dimss__) const {
    dimss__.clear();
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nt),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nt),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(Q),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(P),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nt),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(T),
                                             static_cast<size_t>(nt),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(rr_1dim__),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(T),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(T),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(D_p_1dim__),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(R_p_1dim__),
                                             static_cast<size_t>(nt),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(ahead),
                                             static_cast<size_t>(nt),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(H_p_1dim__),
                                             static_cast<size_t>(nt),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(ahead),
                                             static_cast<size_t>(nt),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(mu_p_1dim__)
                                             , static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(ahead),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(rts_p_1dim__)
                                             , static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(ahead),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(rr_p_1dim__)
                                             , static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(log_lik_1dim__)
                                             });
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nt)});
    
    } // get_dims() 
    
  inline void constrained_param_names(
                                      std::vector<std::string>& param_names__,
                                      bool emit_transformed_parameters__ = true,
                                      bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "phi0" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "phi" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "theta" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "beta" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "nu");
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "c_h" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= Q; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "a_h" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "b_h" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "R" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "D1_init" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          {
            for (int sym3__ = 1; sym3__ <= T; ++sym3__) {
              {
                param_names__.emplace_back(std::string() + "H" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
              }}
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= rr_1dim__; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "rr" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "mu" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "D" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    if (emit_transformed_parameters__) {
      
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= D_p_1dim__; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "D_p" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            {
              for (int sym3__ = 1; sym3__ <= R_p_1dim__; ++sym3__) {
                {
                  param_names__.emplace_back(std::string() + "R_p" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
                }}
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            {
              for (int sym3__ = 1; sym3__ <= ahead; ++sym3__) {
                {
                  param_names__.emplace_back(std::string() + "R_forecasted" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
                }}
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            {
              for (int sym3__ = 1; sym3__ <= H_p_1dim__; ++sym3__) {
                {
                  param_names__.emplace_back(std::string() + "H_p" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
                }}
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            {
              for (int sym3__ = 1; sym3__ <= ahead; ++sym3__) {
                {
                  param_names__.emplace_back(std::string() + "H_forecasted" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
                }}
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= mu_p_1dim__; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "mu_p" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= ahead; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "mu_forecasted" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= rts_p_1dim__; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "rts_p" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= ahead; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "rts_forecasted" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= rr_p_1dim__; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "rr_p" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= log_lik_1dim__; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "log_lik" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "vd" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "ma_d" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "ar_d" + '.' + std::to_string(sym1__));
        }}
    }
    
    } // constrained_param_names() 
    
  inline void unconstrained_param_names(
                                        std::vector<std::string>& param_names__,
                                        bool emit_transformed_parameters__ = true,
                                        bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "phi0" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "phi" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "theta" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "beta" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "nu");
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "c_h" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= Q; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "a_h" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "b_h" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= ((nt * (nt - 1)) / 2); ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "R" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "D1_init" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= (nt + ((nt * (nt - 1)) / 2)); ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "H" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= rr_1dim__; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "rr" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "mu" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "D" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    if (emit_transformed_parameters__) {
      
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= D_p_1dim__; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "D_p" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= ((nt * (nt - 1)) / 2); ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= R_p_1dim__; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "R_p" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= ((nt * (nt - 1)) / 2); ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= ahead; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "R_forecasted" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= (nt + ((nt * (nt - 1)) / 2)); ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= H_p_1dim__; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "H_p" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= (nt + ((nt * (nt - 1)) / 2)); ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= ahead; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "H_forecasted" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= mu_p_1dim__; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "mu_p" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= ahead; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "mu_forecasted" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= rts_p_1dim__; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "rts_p" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= ahead; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "rts_forecasted" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= rr_p_1dim__; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "rr_p" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= log_lik_1dim__; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "log_lik" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "vd" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "ma_d" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "ar_d" + '.' + std::to_string(sym1__));
        }}
    }
    
    } // unconstrained_param_names() 
    
  inline std::string get_constrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"phi0\",\"type\":{\"name\":\"vector\",\"length\":" << nt << "},\"block\":\"parameters\"},{\"name\":\"phi\",\"type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "},\"block\":\"parameters\"},{\"name\":\"theta\",\"type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "},\"block\":\"parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" << nt << "},\"block\":\"parameters\"},{\"name\":\"nu\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"c_h\",\"type\":{\"name\":\"vector\",\"length\":" << nt << "},\"block\":\"parameters\"},{\"name\":\"a_h\",\"type\":{\"name\":\"array\",\"length\":" << Q << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"parameters\"},{\"name\":\"b_h\",\"type\":{\"name\":\"array\",\"length\":" << P << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"parameters\"},{\"name\":\"R\",\"type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "},\"block\":\"parameters\"},{\"name\":\"D1_init\",\"type\":{\"name\":\"vector\",\"length\":" << nt << "},\"block\":\"parameters\"},{\"name\":\"H\",\"type\":{\"name\":\"array\",\"length\":" << T << ",\"element_type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "}},\"block\":\"parameters\"},{\"name\":\"rr\",\"type\":{\"name\":\"array\",\"length\":" << rr_1dim__ << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"parameters\"},{\"name\":\"mu\",\"type\":{\"name\":\"array\",\"length\":" << T << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"parameters\"},{\"name\":\"D\",\"type\":{\"name\":\"array\",\"length\":" << T << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"parameters\"},{\"name\":\"D_p\",\"type\":{\"name\":\"array\",\"length\":" << D_p_1dim__ << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"generated_quantities\"},{\"name\":\"R_p\",\"type\":{\"name\":\"array\",\"length\":" << R_p_1dim__ << ",\"element_type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "}},\"block\":\"generated_quantities\"},{\"name\":\"R_forecasted\",\"type\":{\"name\":\"array\",\"length\":" << ahead << ",\"element_type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "}},\"block\":\"generated_quantities\"},{\"name\":\"H_p\",\"type\":{\"name\":\"array\",\"length\":" << H_p_1dim__ << ",\"element_type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "}},\"block\":\"generated_quantities\"},{\"name\":\"H_forecasted\",\"type\":{\"name\":\"array\",\"length\":" << ahead << ",\"element_type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "}},\"block\":\"generated_quantities\"},{\"name\":\"mu_p\",\"type\":{\"name\":\"array\",\"length\":" << mu_p_1dim__ << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"generated_quantities\"},{\"name\":\"mu_forecasted\",\"type\":{\"name\":\"array\",\"length\":" << ahead << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"generated_quantities\"},{\"name\":\"rts_p\",\"type\":{\"name\":\"array\",\"length\":" << rts_p_1dim__ << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"generated_quantities\"},{\"name\":\"rts_forecasted\",\"type\":{\"name\":\"array\",\"length\":" << ahead << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"generated_quantities\"},{\"name\":\"rr_p\",\"type\":{\"name\":\"array\",\"length\":" << rr_p_1dim__ << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"generated_quantities\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"array\",\"length\":" << log_lik_1dim__ << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"generated_quantities\"},{\"name\":\"vd\",\"type\":{\"name\":\"array\",\"length\":" << nt << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"generated_quantities\"},{\"name\":\"ma_d\",\"type\":{\"name\":\"array\",\"length\":" << nt << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"generated_quantities\"},{\"name\":\"ar_d\",\"type\":{\"name\":\"array\",\"length\":" << nt << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_constrained_sizedtypes() 
    
  inline std::string get_unconstrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"phi0\",\"type\":{\"name\":\"vector\",\"length\":" << nt << "},\"block\":\"parameters\"},{\"name\":\"phi\",\"type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "},\"block\":\"parameters\"},{\"name\":\"theta\",\"type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "},\"block\":\"parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" << nt << "},\"block\":\"parameters\"},{\"name\":\"nu\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"c_h\",\"type\":{\"name\":\"vector\",\"length\":" << nt << "},\"block\":\"parameters\"},{\"name\":\"a_h\",\"type\":{\"name\":\"array\",\"length\":" << Q << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"parameters\"},{\"name\":\"b_h\",\"type\":{\"name\":\"array\",\"length\":" << P << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"parameters\"},{\"name\":\"R\",\"type\":{\"name\":\"vector\",\"length\":" << ((nt * (nt - 1)) / 2) << "},\"block\":\"parameters\"},{\"name\":\"D1_init\",\"type\":{\"name\":\"vector\",\"length\":" << nt << "},\"block\":\"parameters\"},{\"name\":\"H\",\"type\":{\"name\":\"array\",\"length\":" << T << ",\"element_type\":{\"name\":\"vector\",\"length\":" << (nt + ((nt * (nt - 1)) / 2)) << "}},\"block\":\"parameters\"},{\"name\":\"rr\",\"type\":{\"name\":\"array\",\"length\":" << rr_1dim__ << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"parameters\"},{\"name\":\"mu\",\"type\":{\"name\":\"array\",\"length\":" << T << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"parameters\"},{\"name\":\"D\",\"type\":{\"name\":\"array\",\"length\":" << T << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"parameters\"},{\"name\":\"D_p\",\"type\":{\"name\":\"array\",\"length\":" << D_p_1dim__ << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"generated_quantities\"},{\"name\":\"R_p\",\"type\":{\"name\":\"array\",\"length\":" << R_p_1dim__ << ",\"element_type\":{\"name\":\"vector\",\"length\":" << ((nt * (nt - 1)) / 2) << "}},\"block\":\"generated_quantities\"},{\"name\":\"R_forecasted\",\"type\":{\"name\":\"array\",\"length\":" << ahead << ",\"element_type\":{\"name\":\"vector\",\"length\":" << ((nt * (nt - 1)) / 2) << "}},\"block\":\"generated_quantities\"},{\"name\":\"H_p\",\"type\":{\"name\":\"array\",\"length\":" << H_p_1dim__ << ",\"element_type\":{\"name\":\"vector\",\"length\":" << (nt + ((nt * (nt - 1)) / 2)) << "}},\"block\":\"generated_quantities\"},{\"name\":\"H_forecasted\",\"type\":{\"name\":\"array\",\"length\":" << ahead << ",\"element_type\":{\"name\":\"vector\",\"length\":" << (nt + ((nt * (nt - 1)) / 2)) << "}},\"block\":\"generated_quantities\"},{\"name\":\"mu_p\",\"type\":{\"name\":\"array\",\"length\":" << mu_p_1dim__ << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"generated_quantities\"},{\"name\":\"mu_forecasted\",\"type\":{\"name\":\"array\",\"length\":" << ahead << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"generated_quantities\"},{\"name\":\"rts_p\",\"type\":{\"name\":\"array\",\"length\":" << rts_p_1dim__ << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"generated_quantities\"},{\"name\":\"rts_forecasted\",\"type\":{\"name\":\"array\",\"length\":" << ahead << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"generated_quantities\"},{\"name\":\"rr_p\",\"type\":{\"name\":\"array\",\"length\":" << rr_p_1dim__ << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"generated_quantities\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"array\",\"length\":" << log_lik_1dim__ << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"generated_quantities\"},{\"name\":\"vd\",\"type\":{\"name\":\"array\",\"length\":" << nt << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"generated_quantities\"},{\"name\":\"ma_d\",\"type\":{\"name\":\"array\",\"length\":" << nt << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"generated_quantities\"},{\"name\":\"ar_d\",\"type\":{\"name\":\"array\",\"length\":" << nt << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_unconstrained_sizedtypes() 
    
  
    // Begin method overload boilerplate
    template <typename RNG>
    inline void write_array(RNG& base_rng,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                            const bool emit_transformed_parameters = true,
                            const bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      std::vector<double> vars_vec(vars.size());
      std::vector<int> params_i;
      write_array_impl(base_rng, params_r, params_i, vars_vec,
          emit_transformed_parameters, emit_generated_quantities, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i) {
        vars.coeffRef(i) = vars_vec[i];
      }
    }
    template <typename RNG>
    inline void write_array(RNG& base_rng, std::vector<double>& params_r,
                            std::vector<int>& params_i,
                            std::vector<double>& vars,
                            bool emit_transformed_parameters = true,
                            bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      write_array_impl(base_rng, params_r, params_i, vars, emit_transformed_parameters, emit_generated_quantities, pstream);
    }
    template <bool propto__, bool jacobian__, typename T_>
    inline T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
                       std::ostream* pstream = nullptr) const {
      Eigen::Matrix<int, -1, 1> params_i;
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
    template <bool propto__, bool jacobian__, typename T__>
    inline T__ log_prob(std::vector<T__>& params_r,
                        std::vector<int>& params_i,
                        std::ostream* pstream = nullptr) const {
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
  
    inline void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream = nullptr) const final {
      std::vector<double> params_r_vec(params_r.size());
      std::vector<int> params_i;
      transform_inits_impl(context, params_i, params_r_vec, pstream);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i) {
        params_r.coeffRef(i) = params_r_vec[i];
      }
    }
    inline void transform_inits(const stan::io::var_context& context,
                                std::vector<int>& params_i,
                                std::vector<double>& vars,
                                std::ostream* pstream = nullptr) const final {
      transform_inits_impl(context, params_i, vars, pstream);
    }        
};
}
using stan_model = model_forecastCCC_namespace::model_forecastCCC;
#ifndef USING_R
// Boilerplate
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_forecastCCC_namespace::profiles__;
}
#endif
#endif
