% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BMSC-plot.R
\name{plot.BMSC}
\alias{plot.BMSC}
\title{Plot estimates from a \code{BMSC} object.}
\usage{
\method{plot}{BMSC}(x, who = "both", type = "interval", CI = 0.95, ...)
}
\arguments{
\item{x}{An object of class \link{BMSC}.}

\item{who}{parameter to choose the estimates to plot
\describe{
        \item{both}{plot in the same graph both controls and the Single Case}
        \item{control}{only the controls}
        \item{single}{only the Single Case \eqn{(\beta + \delta)}}
        \item{delta}{only the difference between the Single Case and controls}
}}

\item{type}{a parameter to select the typology of graph
\describe{
        \item{interval}{the estimates will be represented by means of pointrange, with median and the boundaries of the credible interval}
        \item{area}{a density plot}
        \item{hist}{a density histogram}
}}

\item{CI}{the dimension of the Credible Interval (or Equally Tailed Interval). Default 0.95.}

\item{...}{other arguments are ignored.}
}
\value{
a plot, a ggplot2 object, or a bayesplot object
}
\description{
Plot estimates from a \code{BMSC} object.
}
\examples{
 \donttest{

# simulation of healthy controls data

Sigma.ctrl <- matrix(cbind(1, .7,  .7, 1) ,nrow=2)

U <- t(chol(Sigma.ctrl))

numobs <- 100

set.seed(123)

random.normal <- matrix( rnorm( n = ncol(U) * numobs, mean = 3, sd = 1),
                         nrow = ncol(U), ncol = numobs)

X = U \%*\% random.normal

dat.ctrl <- as.data.frame(t(X))

names(dat.ctrl) <- c("y","x")

cor(dat.ctrl)

# simulation of patient data

Sigma.pt <- matrix(cbind(1, 0,  0, 1) ,nrow=2)

U <- t(chol(Sigma.pt))

numobs <- 20

set.seed(0)

random.normal <- matrix( rnorm( n = ncol(U) * numobs, mean = 3, sd = 1),
                 nrow = ncol(U), ncol = numobs)

X = U \%*\% random.normal

dat.pt <- as.data.frame(t(X))

names(dat.pt) <- c("y","x")

cor(dat.pt)

# fit the single case model

mdl.reg <- BMSC(y ~ x, data_ctrl = dat.ctrl, data_sc = dat.pt, seed = 10)

# summarize the data

summary(mdl.reg)

# plot the results of both patient and control group

plot(mdl.reg)

# plot the results of the patient

plot(mdl.reg, who = "single")

# plot the results of the difference between the control group and the patient

plot(mdl.reg, who = "delta")

# density plots

plot(mdl.reg, type = "area")

# histograms

plot(mdl.reg, type = "hist")
}

}
