% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render_bpmn.R
\name{render_bpmn}
\alias{render_bpmn}
\alias{render_bpmn.bpmn}
\title{Render BPMN diagram.}
\usage{
render_bpmn(
  bpmn,
  viewer.suppress = FALSE,
  width = NULL,
  height = NULL,
  elementId = NULL,
  xml_version_number = "1.0",
  xml_encoding_declaration = "UTF-8",
  ...
)

\method{render_bpmn}{bpmn}(
  bpmn,
  viewer.suppress = FALSE,
  width = NULL,
  height = NULL,
  elementId = NULL,
  xml_version_number = "1.0",
  xml_encoding_declaration = "UTF-8",
  ...
)
}
\arguments{
\item{bpmn}{A BPMN object as a list of data.frames for the BPMN elements and
an XML document for the XML-based interchange format for the BPMN process.}

\item{viewer.suppress}{Never display the widget within the RStudio Viewer
(useful for widgets that require a large amount of space for rendering).
Defaults to FALSE.}

\item{width}{Fixed width for widget (in css units). The default is NULL,
which results in intelligent automatic sizing based on the widget's
container.}

\item{height}{Fixed height for widget (in css units). The default is NULL,
which results in intelligent automatic sizing based on the widget's
container.}

\item{elementId}{Use an explicit element ID for the widget (rather than an
automatically generated one). Useful if you have other JavaScript that
needs to explicitly discover and interact with a specific widget instance.}

\item{xml_version_number}{The version of the XML standard used.}

\item{xml_encoding_declaration}{The character encoding used in the XML
declaration. \sQuote{UTF-8} is the default encoding used.}

\item{...}{Additional arguments passed to methods.}
}
\value{
Rendered BPMN model in htmlwidget.
}
\description{
This renders a BPMN diagram based on a BPMN object.
}
\examples{

library(dplyr)
nodes <- tibble(id = "task", name = "Task name",
objectType = "task", gatewayDirection = NA)
events <- tibble(id = c("start","end"), name = c("Start event","End event"),
objectType = c("startEvent","endEvent"))
flows <- tibble(id = c("flow1","flow2"), name = c("flow1","flow2"),
sourceRef = c("start","task"), targetRef = c("task","end"),
objectType = c("sequenceFlow","sequenceFlow"))
model <- create_bpmn(nodes, flows, events)
render_bpmn(model)

}
\author{
Alessio Nigro
}
