% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bzinb.R
\name{bzinb.se}
\alias{bzinb.se}
\title{The bivariate zero-inflated negative binomial distribution 
   - Standard error estimation}
\usage{
bzinb.se(xvec, yvec, a0, a1, a2, b1, b2, p1, p2, p3, p4, param = NULL, ...)
}
\arguments{
\item{xvec, yvec}{a pair of bzinb random vectors. nonnegative integer vectors. 
If not integers, they will be rounded to the nearest integers.}

\item{a0, a1, a2}{shape parameters of the latent gamma variables. They must be positive.}

\item{b1, b2}{scale parameters for the latent gamma variables. They must be positive.}

\item{p1, p2, p3, p4}{proportions summing up to 1 (\code{p1 + p2 + p3 + p4 = 1}). 
\code{p1} is the probability of both latent Poisson variables being observed. 
\code{p2} is the probability of only the first Poisson variables being observed.
\code{p3} is the probability of only the second Poisson variables being observed, and
\code{p4} is the probability of both Poisson variables being dropped out.}

\item{param}{a vector of parameters (\code{(a0, a1, a2, b1, b2, p1, p2, p3, p4)}). 
See \code{\link{bzinb}} for more detail.}

\item{...}{Other arguments passed on to \code{bzinb} function, when \code{param} is 
\code{NULL}.}
}
\value{
Standard error of \code{rho},  \code{logit.rho},  \code{a0, a1, a2, b1, b2, p1, p2, p3},
 and \code{p4} estimates, variance-covariance matrix (\code{vcov}) and information matrix.
 See \code{\link{bzinb}} for more detail. \code{iter} is \code{NA}, if the \code{param} 
 is given.
}
\description{
Standard errors of the BZINB distribution parameter estimates are 
   calculated based on maximum likelihood estimation. If \code{param} is \code{NULL},
   the parameters are first estimated by \code{bzinb} function.
}
\examples{
set.seed(1)
data1 <- rbzinb(n = 20, a0 = 1, a1 = 1, a2 = 1, 
                b1 = 1, b2 = 1, p1 = 0.5, p2 = 0.2, 
                p3 = 0.2, p4 = 0.1)
bzinb.se(xvec = data1[,1], yvec = data1[,2], 
         param = c(5.5, 0.017, 0.017, 0.33, 0.36, 
                   0.53, 0.30, 0.08, 0.09))

}
\references{
Cho, H., Liu, C., Preisser, J., and Wu, D. (In preparation), "A bivariate 
 zero-inflated negative binomial model for identifying underlying dependence"
}
\author{
Hunyong Cho, Chuwen Liu, Jinyoung Park, and Di Wu
}
