% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zotero_index.R
\name{ZoteroIndex}
\alias{ZoteroIndex}
\title{Create an index of Zotero items}
\usage{
ZoteroIndex(data)
}
\arguments{
\item{data}{Tibble containing Zotero-type metadata (e.g., from Cristin)}
}
\value{
A tibble
}
\description{
The function creates a index containing key information about
  the present Zotero items
}
\details{
Please see
  \href{https://oeysan.github.io/c2z/}{https://oeysan.github.io/c2z/}
}
\examples{
\donttest{
  # Access the default group library
  example = Zotero(
    user = FALSE,
    id = "4827927",
    api = "RqlAmlH5l1KPghfCseAq1sQ1",
    library = TRUE
  )
  # Print index using `ZoteroIndex`
  if (any(nrow(example$items))) {
  ZoteroIndex(example$items) |>
    dplyr::select(name) |>
    print(width = 80)
  }
}
}
\seealso{
\code{\link[dplyr]{filter}}, \code{\link[dplyr]{mutate}},
 \code{\link[dplyr]{across}}, \code{\link[dplyr]{na_if}},
 \code{\link[dplyr]{case_when}}, \code{\link[dplyr]{arrange}},
 \code{\link[dplyr]{group_by}}, \code{\link[dplyr]{context}},
 \code{\link[dplyr]{select}}
 \code{\link[tidyselect]{everything}}
 \code{\link[purrr]{pmap}}
}
