% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_assess.R
\name{distance_measures}
\alias{distance_measures}
\alias{calculateDG}
\alias{calculateDL}
\alias{calculateDML}
\title{Calculate difference between S and Sigma_hat}
\usage{
calculateDG(
  .object = NULL,
  .matrix1 = NULL,
  .matrix2 = NULL,
  .saturated = FALSE,
  ...
)

calculateDL(
  .object = NULL,
  .matrix1 = NULL,
  .matrix2 = NULL,
  .saturated = FALSE,
  ...
)

calculateDML(
  .object = NULL,
  .matrix1 = NULL,
  .matrix2 = NULL,
  .saturated = FALSE,
  ...
)
}
\arguments{
\item{.object}{An R object of class \link{cSEMResults} resulting from a call to \code{\link[=csem]{csem()}}.}

\item{.matrix1}{A \code{matrix} to compare.}

\item{.matrix2}{A \code{matrix} to compare.}

\item{.saturated}{Logical. Should a saturated structural model be used?
Defaults to \code{FALSE}.}

\item{...}{Ignored.}
}
\value{
A single numeric value giving the distance between two matrices.
}
\description{
Calculate the difference between the empirical (S)
and the model-implied indicator variance-covariance matrix (Sigma_hat)
using different distance measures.
}
\details{
The distances may also be computed for any two matrices A and B by supplying
A and B directly via the \code{.matrix1} and \code{.matrix2} arguments.
If A and B are supplied \code{.object} is ignored.
}
\section{Functions}{
\itemize{
\item \code{calculateDG()}: The geodesic distance (dG).

\item \code{calculateDL()}: The squared Euclidean distance

\item \code{calculateDML()}: The distance measure (fit function) used by ML

}}
