% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/site_convert.R
\name{site_convert}
\alias{site_convert}
\title{Convert ICD-O-3 topography codes}
\usage{
site_convert(x, validate = TRUE)
}
\arguments{
\item{x}{The ICD-O-3 site codes to be converted.}

\item{validate}{Logical indicating whether to make the converted values
have valid ICD-O-3 sites codes between C00.0 and C97.0, setting any invalid
codes to \code{NA}. Default value is \code{TRUE}.}
}
\value{
Returns a converted ICD-O-3 topography code in a numeric format.
}
\description{
Converts ICD-O-3 topography codes in to a numeric format.
It removes the "C" from the beginning of the string if present, and ensures
that the codes are valid ICD-O-3 site codes.
}
\details{
Takes in a character or numeric vector of ICD-O-3 site codes and converts
them to a standardized numeric format. The function will remove the "C"
from the beginning of the string if present. It will also automatically
detect if the codes have are in decimal ("C34.1") or integer ("C341") format
and convert them.

If \code{validate} is set to \code{TRUE}, the function checks if the topography
codes are valid ICD-O-3 site codes for neoplasms which range from
C00.0 to C97.0. Any invalid codes will be set to \code{NA} and a warning will be
issued indicating the number of invalid codes found.
}
\examples{
# Character input with and without "C" at the beginning
site_convert(c("C80.1", "C34.1", "C50.3", "C424", "80.9"))

# Numeric input
site_convert(c(80.1, 8.1, 81, 708)) # Numeric input
}
