% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resolve.R
\name{resolve_feature_names}
\alias{resolve_feature_names}
\title{Canonicalise feature names accounting for aliases and character case}
\usage{
resolve_feature_names(feature_names, feature_type, unmatched = "error")
}
\arguments{
\item{feature_names}{Character vector of feature names in the data.}

\item{feature_type}{Type of map feature. See \code{\link[=feature_types]{feature_types()}} for a list of
registered types.}

\item{unmatched}{Controls behaviour when \code{feature_names} contains values
that do not match registered feature names. Possible values are
\code{"error"} to throw an error or
\code{"pass"} to return the original values unaltered.}
}
\value{
Character vector of the canonicalised names.
}
\description{
Names are resolved by checking for the first match using:
\enumerate{
\item case sensitive match, then
\item case sensitive match using aliases, then
\item case insensitive match, then
\item case insensitive match using aliases.
}
}
\examples{
resolve_feature_names(c("LEE", "ansoN"), feature_type = "sf.nc")
resolve_feature_names(c("LEE", "ansoNe"), feature_type = "sf.nc", unmatched = "pass")
}
