% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/padding-all.R
\name{padding_all}
\alias{padding_all}
\alias{padding_top}
\alias{padding_right}
\alias{padding_bottom}
\alias{padding_left}
\alias{padding_horizontal}
\alias{padding_vertical}
\title{Padding}
\usage{
padding_all(x, ...)

padding_top(x, ...)

padding_right(x, ...)

padding_bottom(x, ...)

padding_left(x, ...)

padding_horizontal(x, ...)

padding_vertical(x, ...)
}
\arguments{
\item{x}{A tag element or \link{.style} pronoun.}

\item{...}{A number specifying the amount of padding. One of,
\itemize{
\item \code{0}
\item \code{1}
\item \code{2}
\item \code{3}
\item \code{4}
\item \code{5}

Use name-value pairs to specify \link{breakpoints}.
}}
}
\value{
An object of the same type as \code{x}.
}
\description{
The \verb{padding_*()} functions adjust a tag element's padding, the space between
the element's border and its content or child elements.
}
\examples{

library(htmltools)

div(
  .style \%>\%
    border_color(theme_primary()) \%>\%
    padding_all(2),
  "A padded element"
)

}
