% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text-break.R
\name{text_break}
\alias{text_break}
\title{Break long text}
\usage{
text_break(x)
}
\arguments{
\item{x}{A tag element or \link{.style} pronoun.}
}
\value{
An object of the same type as \code{x}.
}
\description{
The \code{text_break()} function is used to break long strings of text within a
tag element.
}
\examples{

library(htmltools)

div(
  .style \%>\%
    text_break(),
  "wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww"
)

}
\seealso{
Other text utilities: 
\code{\link{text_alignment}()},
\code{\link{text_color}()},
\code{\link{text_decoration}()},
\code{\link{text_height}()},
\code{\link{text_selection}()},
\code{\link{text_style}()},
\code{\link{text_transform}()},
\code{\link{text_weight}()},
\code{\link{text_wrap}()}
}
\concept{text utilities}
