% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate.R
\name{calc_scags}
\alias{calc_scags}
\title{Compute selected scagnostics on subsets}
\usage{
calc_scags(
  x,
  y,
  scags = c("outlying", "stringy", "striated", "striated2", "clumpy", "clumpy2",
    "sparse", "skewed", "convex", "skinny", "monotonic", "splines", "dcor"),
  out.rm = TRUE,
  euclid = FALSE
)
}
\arguments{
\item{x}{numeric vector}

\item{y}{numeric vector}

\item{scags}{collection of strings matching names of
scagnostics to calculate: outlying, stringy, striated,
striated2, striped, clumpy, clumpy2, sparse, skewed, convex,
skinny, monotonic, splines, dcor}

\item{out.rm}{logical indicator to indicate if outliers should be removed before calculating non outlying measures}

\item{euclid}{logical indicator to use Euclidean distance}
}
\value{
A data frame that gives the single plot's scagnostic score.
}
\description{
Compute selected scagnostics on subsets
}
\examples{
# Calculate selected scagnostics on a single pair
calc_scags(anscombe$x1, anscombe$y1, scags=c("monotonic", "outlying"))

# Compute on long form data, or subsets
# defined by a categorical variable
require(dplyr)
datasaurus_dozen \%>\%
  group_by(dataset) \%>\%
  summarise(calc_scags(x,y, scags=c("monotonic", "outlying", "convex")))

}
\seealso{
calc_scags_wide
}
