% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ContextualInfluence.R
\name{ciu.contrastive}
\alias{ciu.contrastive}
\title{Create a contrastive explanation between two instances}
\usage{
ciu.contrastive(ciu.result1, ciu.result2)
}
\arguments{
\item{ciu.result1}{First instance as \code{ciu.result} object.}

\item{ciu.result2}{Second instance as \code{ciu.result} object.}
}
\value{
Contrastive influence values, where CU values of second instance are used as
baseline for first instance.
}
\description{
Create a contrastive explanation between two instances
}
\examples{
library(ciu)
library(MASS)
test.ind <- 100
iris_test <- iris[test.ind, 1:4]
iris_train <- iris[-test.ind, 1:4]
iris_lab <- iris[[5]][-test.ind]
model <- lda(iris_train, iris_lab)
# Create CIU object
ciu <- ciu.new(model, Species~., iris)
# First case: why is this a versicolor and not a virginica?
meta <- ciu$meta.explain(iris_test)
ciuvals.versicolor <- ciu.list.to.frame(meta$ciuvals, out.ind = 2)
ciuvals.virginica <- ciu.list.to.frame(meta$ciuvals, out.ind = 3)
# Now the contrastive part:
why.versicolor.not.virginica <- ciu.contrastive(ciuvals.versicolor, ciuvals.virginica)
}
\author{
Kary Främling
}
