% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ciu.R
\name{ciu.plot.3D}
\alias{ciu.plot.3D}
\title{ciu.plot.3D}
\usage{
ciu.plot.3D(
  ciu,
  instance,
  ind.inputs,
  ind.output,
  in.min.max.limits = NULL,
  n.points = 40,
  main = NULL,
  xlab = NULL,
  ylab = NULL,
  zlab = NULL,
  zlim = NULL,
  ...
)
}
\arguments{
\item{ciu}{\code{ciu} object as created with \link{ciu} function (not to be confused
with \code{CIU} object as created by \link{ciu.new}).}

\item{instance}{Input values for the instance to explain. Should be a
\link{data.frame} even though a \code{vector} or \code{matrix} might work too if input
names and other needed metadata can be deduced from the dataset or other
parameters given to \code{\link{ciu.new}}.}

\item{ind.inputs}{Indices of input features to plot.}

\item{ind.output}{Index of output to plot.}

\item{in.min.max.limits}{\link{data.frame} or \link{matrix} with one row per output
and two columns, where the first column indicates the minimal value and the
second column the maximal value for that output. ONLY NEEDED HERE IF not
given as parameter to \link{ciu.new} or if the limits are different for this
specific instance than the default ones.}

\item{n.points}{Number of x/y-axis points to use.}

\item{main}{a main title for the plot, see also \code{\link[graphics]{title}}.}

\item{xlab}{a label for the x axis, defaults to a description of \code{x}.}

\item{ylab}{a label for the y axis, defaults to a description of \code{y}.}

\item{zlab}{Label to use for Z-axis. Default: NULL.}

\item{zlim}{Limits to use for Z-axis. Default: NULL.}

\item{...}{other \link[graphics]{graphical parameters} (see \code{\link[graphics]{par}} and
    section \sQuote{Details} below).}
}
\value{
"void", or whatever happens to be result of last instruction.
}
\description{
Function for 3D plotting the effect of changing values of two inputs on one output.
}
\author{
Kary Främling
}
