% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pk_1cmt_inf_dose_for_range.R
\name{pk_1cmt_inf_dose_for_range}
\alias{pk_1cmt_inf_dose_for_range}
\title{Calculate dose based on a given AUC24, Cmax, and Cmin, assuming 1-compartment model}
\usage{
pk_1cmt_inf_dose_for_range(
  target = 500,
  type = "auc",
  conc_range = c(10, 40),
  parameters = list(),
  interval = 24,
  t_inf = 1,
  optimize_interval = TRUE,
  round_interval = TRUE
)
}
\arguments{
\item{target}{numeric value of target}

\item{type}{target type, one of `auc`, `auc24`, `ctrough`, `cmin`}

\item{conc_range}{concentration range to stay within, vector of length 2}

\item{parameters}{list of `CL` and `V`, or `KEL` and `CL`}

\item{interval}{dosing interval}

\item{t_inf}{infusion time}

\item{optimize_interval}{find optimal interval (to stay within `conc_range`?}

\item{round_interval}{round interval to nearest nominal interval?}
}
\description{
Calculate dose based on a given AUC24, Cmax, and Cmin, assuming 1-compartment model
}
