% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/year_chart.R
\name{year_chart}
\alias{year_chart}
\title{Plot Values on Each Month of a Year}
\usage{
year_chart(mvalue, lgnm = "Value", width = 0.9, high = "yellow", low = "green")
}
\arguments{
\item{mvalue}{A numeric vector of length 12, with values for each month (Jan–Dec).
If you have it in a data frame, extract it (e.g. \code{data$mvalue}).}

\item{lgnm}{Title of the legend (default \code{"Value"}).}

\item{width}{Width of bars.}

\item{high}{Color name for high values (default \code{"yellow"}).}

\item{low}{Color name for low values (default \code{"green"}).}
}
\value{
A \code{ggplot} object, which can be further modified with \code{ggplot2} functions.
}
\description{
This function plots values corresponding to each month on a rose plot.
}
\examples{
syltmp <- c(18.4, 20.8, 24.3, 26.0, 26.8, 27.6, 28.0,
            28.2, 27.9, 26.7, 23.3, 19.7)
year_chart(mvalue = syltmp)
}
\seealso{
\code{\link[=day_chart]{day_chart()}} for plotting values on a day by hours
\code{\link[=week_chart]{week_chart()}} for plotting values in a week by days
\code{\link[=cyclic_chart]{cyclic_chart()}} for plotting values by arbitrary period
}
