% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cointReg-D-OLS.R
\name{getLeadLag}
\alias{getLeadLag}
\title{Leads and Lags}
\usage{
getLeadLag(x, y, deter, max.lag, max.lead, ic = c("AIC", "BIC"),
  symmet = FALSE, check = FALSE)
}
\arguments{
\item{x}{[\code{numeric} | \code{matrix} | \code{data.frame}]\cr
RHS variables on which to apply the D-OLS estimation (see Details).}

\item{y}{[\code{numeric} | \code{matrix} | \code{data.frame}]\cr
LHS variable(s) on which to apply the D-OLS estimation (see Details).
Has to be one-dimensional. If \code{matrix}, it may
have only one row or column, if \code{data.frame} just one column.}

\item{deter}{[\code{numeric} | \code{matrix} | \code{data.frame} |
            \code{NULL}]\cr
Deterministic variable to include in the equation (see Details). If it's
\code{NULL} or missing, no deterministic variable is included in the model.}

\item{max.lead, max.lag}{[\code{numeric(1)}]\cr
Maximal numbers of leads and lags, have to be non-negative integer values.}

\item{ic}{[\code{character(1)}]\cr
Information criterion (one of \code{"AIC"} or \code{"BIC"}).}

\item{symmet}{[\code{logical(1)}]\cr
If \code{TRUE}, only looks for equal leads and lags.}

\item{check}{[\code{logical}]\cr
Wheather to check (and if necessary convert) the arguments.
See \code{\link{checkVars}} for further information.}
}
\value{
[\code{numeric(2)}]. "Optimal" numbers of leads and lags.
}
\description{
Generates "optimal" numbers of leads and lags for the Dynamic OLS estimator.
}
\examples{
set.seed(1909)
y <- matrix(cumsum(rnorm(100)), ncol = 1)
x <- matrix(rep(y, 4) + rnorm(400, mean = 3, sd = 2), ncol = 4)
deter <- cbind(1, 1:100)
cointReg:::getLeadLag(x = x, y = y, deter = deter, max.lag = 5,
                      max.lead = 5, ic = "AIC", symmet = FALSE)
}
\seealso{
Other D-OLS: \code{\link{cointRegD}},
  \code{\link{getModD}}, \code{\link{makeLeadLagMatrix}}
}

