% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getTopCol.R
\name{getTopCol}
\alias{getTopCol}
\title{getTopCol}
\usage{
getTopCol(
  path,
  n = NULL,
  exclude = TRUE,
  sig = 4,
  avgCols = TRUE,
  n_clusters = 5,
  customExclude = NULL
)
}
\arguments{
\item{path}{Character, the path to the image file (either jpg or png).}

\item{n}{Integer, the number of top colors to return. If NULL (default), return all colors.}

\item{exclude}{Logical, whether to exclude black and white shades. Default is TRUE.}

\item{sig}{Integer, the number of decimal places for the color percentage. Default is 4.}

\item{avgCols}{Logical, whether to average the colors by groups. Default is TRUE.}

\item{n_clusters}{Integer, the number of clusters to use for grouping colors. Default is 5.}

\item{customExclude}{Character vector. Optional vector of custom color codes in HEX format to be excluded.}
}
\value{
A data frame with the top colors, their frequency, and percentage in the image.
}
\description{
Get top colors from an image. This function reads an image file, extracts the colors,
and returns the top n colors based on their frequency in the image.
Optionally, black and white shades can be excluded, and the colors can be grouped and averaged.
}
