% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{optimization_path}
\alias{optimization_path}
\title{Extract Optimization Path as Data Frame}
\usage{
optimization_path(x, ...)
}
\arguments{
\item{x}{An mle_numerical result with trace_data, or an mle_trace_data object}

\item{...}{Additional arguments (unused)}
}
\value{
A data frame with columns:
  \itemize{
    \item \code{iteration}: Iteration number
    \item \code{loglike}: Log-likelihood value (if traced)
    \item \code{grad_norm}: Gradient norm (if traced)
    \item \code{time}: Elapsed time in seconds (if traced)
    \item \code{theta_1}, \code{theta_2}, ...: Parameter values (if path traced)
  }
}
\description{
Converts the trace data from an MLE result into a tidy data frame for
custom analysis and plotting (e.g., with ggplot2).
}
\examples{
\donttest{
# Get optimization path as data frame
problem <- mle_problem(
  loglike = function(theta) -sum((theta - c(3, 2))^2),
  constraint = mle_constraint(support = function(theta) TRUE)
)
trace_cfg <- mle_trace(values = TRUE, path = TRUE)
result <- gradient_ascent(max_iter = 30)(problem, c(0, 0), trace = trace_cfg)

path_df <- optimization_path(result)
head(path_df)
}

}
