% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inequ.R
\name{concstats_palma}
\alias{concstats_palma}
\title{Palma ratio}
\usage{
concstats_palma(x, na.rm = TRUE)
}
\arguments{
\item{x}{A non-negative numeric vector.}

\item{na.rm}{A logical vector that indicates whether \code{NA} values should
be excluded or not. Must be either \code{TRUE} or \code{FALSE}. The default
is \code{TRUE}.
If set to \code{FALSE} the computation yields \code{NA} if \code{NA} values
are present.}
}
\value{
A single numeric measure.
}
\description{
Palma ratio
}
\details{
\code{concstats_palma} measures the ratio of inequality (normally used with
income inequality) of the top 10 percent to the bottom 40 percent.
}
\examples{
# a vector of market shares
x <- c(0.4, 0.2, 0.25, 0.1, 0.05)
concstats_palma(x)
# a vector with NA values
x <- c(0.4, 0.2, 0.25, 0.1, 0.05, NA)
concstats_palma(x, na.rm = FALSE)

}
\references{
Palma, J. G. (2006). "Globalizing Inequality: 'Centrifugal' and
'Centripetal' Forces at Work", DESA Working Paper No. 35.
}
