% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jackplus.R
\name{conformal.fun.jackplus}
\alias{conformal.fun.jackplus}
\title{Functional Jackknife + Prediction Regions}
\usage{
conformal.fun.jackplus(x, t_x, y, t_y, x0, train.fun, predict.fun, alpha = 0.1)
}
\arguments{
\item{x}{The input variable, a list of n elements. Each element is composed by a list
of p vectors(with variable length, since the evaluation grid may change).
If x is NULL, the function will sample it from a gaussian.}

\item{t_x}{The grid points for the evaluation of function x. It is a list of vectors.
If the x data type is "fData" or "mfData" is must be NULL.}

\item{y}{The response variable. It is either, as with x, a list of list of
vectors or an fda object (of type fd, fData, mfData).}

\item{t_y}{The grid points for the evaluation of function y_val. It is a list of vectors.
If the y_val data type is "fData" or "mfData" is must be NULL.}

\item{x0}{The new points to evaluate, a list of n0 elements. Each element is composed
by a list of p vectors(with variable length).}

\item{train.fun}{A function to perform model training, i.e., to produce an
estimator of E(Y|X), the conditional expectation of the response variable
Y given features X. Its input arguments should be x: list of features,
and y: list of responses.}

\item{predict.fun}{A function to perform prediction for the (mean of the)
responses at new feature values. Its input arguments should be out: output
produced by train.fun, and newx: feature values at which we want to make
predictions.}

\item{alpha}{Miscoverage level for the prediction intervals, i.e., intervals
with coverage 1-alpha are formed. Default for alpha is 0.1.}
}
\value{
A list containing lo, up, tn. lo and up are lists of length n0,
containing lists of length p, with vectors of lower and upper bounds.
tn is the list of the grid evaluations.#'
}
\description{
Compute prediction regions using functional Jackknife + inference.
}
\details{
The work is an extension of the univariate approach to jackknife +
 inference to a multivariate functional context, exploiting the concept of
 depth measures.

This function is based on the package future.apply to
 perform parallelisation. If this package is not installed, then the function
 will abort.
}
\examples{
library(roahd)

N = 3
P= 3
grid = seq( 0, 1, length.out = P )
C = exp_cov_function( grid, alpha = 0.3, beta = 0.4 )
values = generate_gauss_fdata( N,
                                      centerline = sin( 2 * pi * grid ),
                                      Cov = C )
fD = fData( grid, values )
x0=list(as.list(grid))
fun=mean_lists()
x0=list(as.list(grid))
fun=mean_lists()
true.jack = conformal.fun.jackplus (x=NULL,t_x=NULL, y=fD,t_y=NULL,
                                    x0=list(x0[[1]]), fun$train.fun,
                                    fun$predict.fun,alpha=0.1)

}
