% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corrSankey.R
\name{corrSankey}
\alias{corrSankey}
\title{corrSankey}
\usage{
corrSankey(mat, threshold = 0, colour = FALSE)
}
\arguments{
\item{mat}{A square correlation matrix to visualise.}

\item{threshold}{A numeric value indicating the minimum absolute correlation value to
include in the diagram. Default is 0 (include all correlations).}

\item{colour}{A logical value indicating whether to color the links based on positive or
negative correlation. Default is FALSE (links are grey).}
}
\value{
A plotly Sankey diagram object.
}
\description{
Create an interactive Sankey diagram to visualize correlations
}
\details{
This function generates a Sankey diagram for a given data frame, correlation method, and
correlation threshold, with an optional colour parameter.
}
\examples{
cm <- cor(mtcars)
corrSankey(mat = cm, threshold = 0.6)
corrSankey(mat = cm, threshold = 0.8, colour = TRUE)

}
