% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cosinor2.R
\encoding{UTF-8}
\name{correct.acrophase}
\alias{correct.acrophase}
\title{Acrophase Correction}
\usage{
correct.acrophase(x)
}
\arguments{
\item{x}{An object of the \code{cosinor.lm} class.}
}
\description{
Corrects the value of the acrophase parameter of the cosinor model, placing it in the appropriate quadrant.
}
\details{
The acrophase parameter of a cosinor model is found by solving an equation with inverse tangent of an expression which contains linearized cosinor parameters. However, multiple numeric entities may result in a same value of tangent and just calculating the inverse tangent may result with the wrong value of the acrophase. This function corrects the acrophase from the \code{cosinor.lm} object according to the procedure from Bingham et al. (1982).
More specifically, the acrophase is calculated as: \deqn{K + g * arctan \vert\frac{\gamma}{\beta}\vert}
where values of \eqn{K} and \eqn{g} depend on the signs of \eqn{\beta} and \eqn{\gamma} and can be derived from the following table:
\tabular{cccc}{
sign \eqn{\beta} \tab sign \eqn{\gamma} \tab K \tab g \cr
+ \tab + \tab 0 \tab -1 \cr
+ \tab - \tab -2\eqn{\pi} \tab 1 \cr
- \tab + \tab -\eqn{\pi} \tab 1 \cr
- \tab - \tab -\eqn{\pi} \tab -1
}
}
\examples{
fit.temperature<-cosinor.lm(Temperature~time(Time), period = 24, data = temperature_zg)
correct.acrophase(fit.temperature)
}
\references{
Bingham, C., Arbogast, B., Guillaume Cornélissen, G., Lee, J.K. & Halberg, F. (1982). Inferential Statistical Methods for Estimating and Comparing Cosinor Parameters. \emph{Chronobiologia}, \emph{9(4)}, 397-439.
}
