% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{g_inv_approx}
\alias{g_inv_approx}
\title{Approximate inverse transformation}
\usage{
g_inv_approx(g, t_grid)
}
\arguments{
\item{g}{the transformation function}

\item{t_grid}{grid of arguments at which to evaluate the transformation function}
}
\value{
A function which can be used for evaluations of the
(approximate) inverse transformation function.
}
\description{
Compute the inverse function of a transformation \code{g} based on a grid search.
}
\examples{
# Sample some data:
y = rpois(n = 500, lambda = 5)

# Empirical CDF transformation:
g_np = g_cdf(y, distribution = 'np')

# Grid for approximation:
t_grid = seq(1, max(y), length.out = 100)

# Approximate inverse:
g_inv = g_inv_approx(g = g_np, t_grid = t_grid)

# Check the approximation:
plot(t_grid, g_inv(g_np(t_grid)), type='p')
lines(t_grid, t_grid)

}
