% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_cpam.R
\name{prepare_cpam}
\alias{prepare_cpam}
\title{Prepare a cpam object}
\usage{
prepare_cpam(
  exp_design,
  count_matrix = NULL,
  t2g = NULL,
  import_type = NULL,
  model_type = c("case-only", "case-control"),
  bootstrap = TRUE,
  filter_fun = "ts_filter",
  filter_fun_args = list(min_reads = 5, min_prop = 3/5),
  regularize = TRUE,
  gene_level = FALSE,
  aggregate_to_gene = !gene_level,
  condition_var = "condition",
  case_value = "treatment",
  num_cores = 1,
  normalize = TRUE,
  fixed_effects = NULL,
  intercept_cc = c("1", condition_var)
)
}
\arguments{
\item{exp_design}{a dataframe or tibble with the experimental design, containing at least a 'time' and a 'sample' column}

\item{count_matrix}{a matrix of counts. Column names must be in 'sample' column of \code{exp_design},}

\item{t2g}{a transcript to gene dataframe or tibble with columns target_id and gene_id}

\item{import_type}{software used for quantification, one of "kallisto", "salmon" ,.... Ignored if \code{count_matrix} is supplied.}

\item{model_type}{"case-only" (default) or "case-control"}

\item{bootstrap}{logical; load bootstrap samples, also called inferential replicates, if available, and rescale counts.}

\item{filter_fun}{filter function to remove lowly expressed genes (default is \code{filter_fun()})}

\item{filter_fun_args}{arguments for filter function}

\item{regularize}{logical; use empirical Bayes regularization of dispersions (default is TRUE)}

\item{gene_level}{logical; aggregate counts to gene level before data preparation and modelling (default is FALSE)}

\item{aggregate_to_gene}{logical; aggregate p values from transcript- to gene-level}

\item{condition_var}{string; column name in \code{exp_design} for the condition variable (for \code{model_type} = "case_control" only)}

\item{case_value}{value of \code{condition_var} that indicates the "case". All other values are deemed to be control}

\item{num_cores}{integer; number of cores to use for parallel computation}

\item{normalize}{logical; use model offsets based on sampling depth and gene length}

\item{fixed_effects}{a model formula of the form \code{~ effect1 + effect2}}

\item{intercept_cc}{string; intercept for case-control model: "1" (default) for common intercept  or "condition"}
}
\value{
an object of class \code{\link{cpam-class}}. The returned object has
methods \code{print} and \code{summary} for displaying information.
See \code{\link{cpam-class}} for details on the structure of the returned object.
}
\description{
Prepare a cpam object
}
\details{
This function prepares a cpam object for analysis.
The function loads count data from files or a matrix,
filters lowly expressed genes, computes normalisation factors,
and estimates dispersions. Many of these steps can be customised or turned off.

When bootstrap samples (inferential replicates) are available, it loads and
summarises these using means, standard errors, and estimated overdispersions.
The latter are a measure of quantification uncertainty and they are used to
rescale the counts which accounts for this uncertainty during the modelling steps.
}
\examples{
library(cpam)

# load gene-only example data
load(system.file("extdata", "exp_design_example.rda", package = "cpam"))
load(system.file("extdata", "count_matrix_example.rda", package = "cpam"))

cpo <- prepare_cpam(exp_design = exp_design_example,
                    count_matrix = count_matrix_example,
                    gene_level = TRUE)
cpo

}
\references{
Pedro L Baldoni, Yunshun Chen, Soroor Hediyeh-zadeh, Yang Liao, Xueyi Dong,
Matthew E Ritchie, Wei Shi, Gordon K Smyth,
Dividing out quantification uncertainty allows efficient assessment of
differential transcript expression with edgeR,
Nucleic Acids Research, Volume 52, Issue 3, 9 February 2024,
Page e13, https://doi.org/10.1093/nar/gkad1167

Yunshun Chen, Lizhong Chen, Aaron T L Lun, Pedro L Baldoni, Gordon K Smyth,
edgeR v4: powerful differential analysis of sequencing data with
expanded functionality and improved support for small counts
and larger datasets, Nucleic Acids Research, Volume 53, Issue 2,
27 January 2025, https://doi.org/10.1093/nar/gkaf018
}
