% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qpdf.R
\name{pdf_overlay_stamp}
\alias{pdf_overlay_stamp}
\title{Overlay a pdf file into another pdf file}
\usage{
pdf_overlay_stamp(input, stamp, output = NULL, password = "")
}
\arguments{
\item{input}{path or url to the input pdf file}

\item{stamp}{pdf file of which the first page is overlayed into each page of
input}

\item{output}{base path of the output file(s)}

\item{password}{string with password to open pdf file}
}
\value{
a character vector with the path of the stamped pdf file
}
\description{
Overlay a pdf file into another pdf file
}
\examples{
pdf_file <- system.file("examples", "sufganiyot.pdf", package = "cpp11qpdf")
stamp_file <- system.file("examples", "header.pdf", package = "cpp11qpdf")
fout <- tempfile()
pdf_overlay_stamp(pdf_file, stamp_file, fout, "")
}
