# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#'@name calibration_cpp
#'@title
#'Calibrating the balancing factors
#'
#'@description
#'Function to calibrate the A and B coefficients of the gravity model through
NULL

#'
#'@param cost_fun The matrix representing the cost function f(D), where D is
NULL

#'@param O A numeric column vector of weights associated to the origin, the
NULL

#'@param D A numeric row vector of destination weights, the attraction
NULL

#'@param delta The error term we can tolerate on the convergence of the values.
#'
#'@returns A list object containing the A and B vectors of coefficients
#'and a vector e to verify convergence speed.
#'
#'@examples
#'cost_fun = matrix(data = c(1,2,3,4,5,6,7,8,9), nrow = 3)
#'O = c(1,2,3)
#'D = c(3,2,1)
#'
NULL

#'@name run_model_cpp
#'@title Run model
#'
#'@description
#'This function is the C++ implementation of run_model, it will run a model
#'
#'@param flows A integer matrix of Origin-Destination flows.
#'@param distance a distance matrix between origins and destinations.
#'@param beta Exponent to use when calculating the cost function.
NULL

#'
#'@returns
#'A list containing an integer matrix with predicted values.
NULL

calibration_cpp <- function(cost_fun, O, D, delta = 0.05) {
    .Call(`_cppSim_calibration_cpp`, cost_fun, O, D, delta)
}

run_model_cpp <- function(flows, distance, beta_, ncores_ = 4L) {
    .Call(`_cppSim_run_model_cpp`, flows, distance, beta_, ncores_)
}

run_simulation_cpp <- function(distance, flows, beta_orig = .25) {
    .Call(`_cppSim_run_simulation_cpp`, distance, flows, beta_orig)
}

#'
#'Function to check availability of OPENMP to run in parallel.
#'If openmp is found, this function returns TRUE
#'
cpp_found_openmp <- function() {
    .Call(`_cppSim_cpp_found_openmp`)
}

#'
NULL

run_model_single_cpp <- function(flow, weight, distance, beta = .25, type = "exp") {
    .Call(`_cppSim_run_model_single_cpp`, flow, weight, distance, beta, type)
}

#'@name mat_exp
#'@description
#'Function to take the exponential of each element of a matrix individually.
#'If an element is x, this function returns exp(coef*x)
#' @param mat A numeric matrix
#' @param coef The exponent
#'
NULL

apply_iter <- function(x, dim = 1L) {
    .Call(`_cppSim_apply_iter`, x, dim)
}

pearsoncoeff <- function(X, Y) {
    .Call(`_cppSim_pearsoncoeff`, X, Y)
}

abs_val <- function(x) {
    .Call(`_cppSim_abs_val`, x)
}

