% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPlayerDataHA.R
\name{getPlayerDataHA}
\alias{getPlayerDataHA}
\title{Return the CSV file and a dataframe of a player's matches along with home/away column}
\usage{
getPlayerDataHA(profileNo,tdir=".",tfile="player001.csv",type="batting",
                     matchType="Test")
}
\arguments{
\item{profileNo}{The profile number of the player}

\item{tdir}{The name of the directory to save the CSV file}

\item{tfile}{The name of the CSV file}

\item{type}{This parameter should be 'batting' for batsman data and 'bowling' for bowlers}

\item{matchType}{Match type - Test, ODI or T20}
}
\value{
dataframe
}
\description{
This function saves the players data as a CSV file and also returns a data frame. A new column
home/away/neutral is added
}
\note{
Maintainer: Tinniam V Ganesh \email{tvganesh.85@gmail.com}
}
\examples{
\dontrun{
#Get data for Tendulkar
df=getPlayerDataHA(profileno=35320,tfile="tendulkarHA.csv")
#Get the bowling data for Jadeja in ODIs
df=getPlayerDataHA(profileNo=234675,tfile="jadejaODIHA.csv",type="bowling",matchType='ODI')
# Get the data for Kohli in T20s for batting
df=getPlayerDataHA(profileNo=253802,tfile="kohliT20HA.csv",matchType="T20")
}
}
\references{
\url{https://www.espncricinfo.com/ci/content/stats/index.html}\cr
\url{https://gigadom.in/}\cr
}
\seealso{
\code{\link{teamWinLossStatusVsOpposition}}
\code{\link{batsman4s}}
}
\author{
Tinniam V Ganesh
}
