% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{NVCAdata_tbl_df}
\alias{NVCAdata_tbl_df}
\title{Interim Data with New Violent Criminal Activity (NVCA)}
\format{
A tibble with 1,891 observations and 19 variables:
\describe{
  \item{Sex}{Sex of the individual (numeric).}
  \item{White}{Indicates if the individual is White (numeric).}
  \item{SexWhite}{Indicates if the individual is both White and male (numeric).}
  \item{Age}{Age of the individual (numeric).}
  \item{PendingChargeAtTimeOfOffense}{Pending charge at the time of offense (numeric).}
  \item{NCorNonViolentMisdemeanorCharge}{Non-violent misdemeanor charge (numeric).}
  \item{ViolentMisdemeanorCharge}{Violent misdemeanor charge (numeric).}
  \item{ViolentFelonyCharge}{Violent felony charge (numeric).}
  \item{NonViolentFelonyCharge}{Non-violent felony charge (numeric).}
  \item{PriorMisdemeanorConviction}{Prior misdemeanor conviction (numeric).}
  \item{PriorFelonyConviction}{Prior felony conviction (numeric).}
  \item{PriorViolentConviction}{Prior violent conviction (numeric).}
  \item{PriorSentenceToIncarceration}{Prior sentence to incarceration (numeric).}
  \item{PriorFTAInPastTwoYears}{Prior failure to appear in the past two years (numeric).}
  \item{PriorFTAOlderThanTwoYears}{Prior failure to appear older than two years (numeric).}
  \item{Staff_ReleaseRecommendation}{Staff release recommendation (numeric).}
  \item{Z}{Binary treatment variable (numeric).}
  \item{D}{Ordinal decision variable (numeric).}
  \item{Y}{Outcome variable indicating new violent criminal activity (numeric).}
}
}
\source{
Interim data on violent criminal activity (NVCA).
}
\usage{
data(NVCAdata_tbl_df)
}
\description{
This dataset contains information related to new violent criminal activity (NVCA) as an outcome.
It includes pre-treatment covariates, a binary treatment variable (Z), an ordinal decision variable (D),
and an outcome variable (Y). The dataset provides a rich set of variables that can be used to analyze
factors influencing violent crime recidivism, with a focus on various demographic and criminal history
attributes.
}
\details{
The dataset name has been changed to 'NVCAdata_tbl_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
crimedatasets package and assists users in identifying its specific characteristics. The suffix
'tbl_df' indicates that the dataset is a tibble in R. The original content has not been modified
in any way.
}
