% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{standardise_sdata}
\alias{standardise_sdata}
\title{Organise atom data in a standard format for later use}
\usage{
standardise_sdata(a, SG, x0, Z, B, occ)
}
\arguments{
\item{a}{Real numeric. Unit cell length in angstroms.}

\item{SG}{SG 2-letters character string. There are only two symmetries
possible when working within 1D crystallography, P1 (no 
symmetry) and P-1 (inversion through the origin). SG can be 
either "P1" or "P-1".}

\item{x0}{Vector of real numerics indicating the expanded atomic
positions in the unit cell.}

\item{Z}{Vector of integers indicating the expanded atomic 
numbers for all atoms in the unit cell.}

\item{B}{Vector of real numerics indicating the expanded B factors 
for all atoms in the unit cell.}

\item{occ}{Vector of real numerics indicating the expanded occupancies
for all atoms in the unit cell.}
}
\value{
A named list with the following elements:
 \itemize{
   \item{a.    Real numeric. Unit cell length in angstroms.}
   \item{SG.   SG 2-letters character string. There are only two symmetries
               possible when working within 1D crystallography, P1 (no 
               symmetry) and P-1 (inversion through the origin). SG can be 
               either "P1" or "P-1".}
   \item{x0.    Vector of real numerics indicating the expanded atomic
                positions in the unit cell.}
   \item{Z.     Vector of integers indicating the expanded 
                atomic numbers for all atoms in the unit cell.}
   \item{B.    Vector of real numerics indicating the expanded 
               B factors for all atoms in the unit cell.}
   \item{occ.  Vector of real numerics indicating the expanded 
               occupancies for all atoms in the unit cell.}
         }
}
\description{
Function to put any group consisting of cell size a, space group SG,
atom coordinates x0, atomic numbers Z, atomic B factors B and atomic
occupancies occ, into a named list with 6 fields. This is then used
as standard input/output format throughout the \emph{crone} package.
}
\examples{
# Create standard format for an arbitrary structure in P1
a <- 20
SG <- "P1"
x0 <- c(2,11,16,19)
Z <- c(6,6,16,8)
B <- c(13,14,5,10)
occ <- c(1,1,1,1)
sdata <- standardise_sdata(a,SG,x0,Z,B,occ)
print(sdata)

}
