% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/judge_line.R
\name{judge_line}
\alias{judge_line}
\title{Title Determine a linear relationship between x and y by Restricted Cubic Splines(RCS) and plot it}
\usage{
judge_line(xname, yname, Data, parm)
}
\arguments{
\item{xname}{A character, the name of the x. If there are multiple covariates, they need to be saved in a vector}

\item{yname}{A character, the name of the y. If there are multiple covariates, they need to be saved in a vector}

\item{Data}{A dataframe containing data of x and y.
The input 'xname' and 'yname' is written in the same way among the 'Data' column names}

\item{parm}{the number of knots of RCS}
}
\value{
A list containing the information of RCS plots.
You can use 'ggpubr::ggarrange()' to plot the list.
The list is a list of ggplot objects.
Each ggplot object is a plot that represents the relationship between one independent variable (from xname) and one dependent variable (from yname).
These plots are based on a linear regression model that uses a restricted cubic spline to handle the independent variable.
Each plot includes a line of predicted values (solid blue line) and a confidence interval for these predictions (transparent blue area).
The title of each plot includes the p-value for non-linearity, as well as the names of the independent and dependent variables.
}
\description{
Title Determine a linear relationship between x and y by Restricted Cubic Splines(RCS) and plot it
}
\examples{
data(test_data1)

# Get RCS plots
result <- judge_line(xname="ASI",yname="HDL_C",Data = test_data1,parm = 4)
## Plot an RCS curve graph
ggpubr::ggarrange(result[[1]])

# Simultaneously determining multiple linear relationships
results <- judge_line("ASI",c("HDL_C","LDL_C"),Data = test_data1,parm = 4)
## Plot many RCS curve graphs
## Adjust 'nrow' and 'ncol' according to actual situation
ggpubr::ggarrange(plotlist = results, nrow = 1, ncol = 2)
}
