% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctACF.R
\name{ctACFresiduals}
\alias{ctACFresiduals}
\title{Calculate Continuous Time Autocorrelation Function (ACF) for Standardized Residuals of ctsem fit.}
\usage{
ctACFresiduals(fit, ...)
}
\arguments{
\item{fit}{A fitted model object generated by the ctsem package.}

\item{...}{Additional arguments to be passed to the \code{\link{ctACF}} function.}
}
\value{
A data table containing the continuous time ACF estimates for standardized residuals.
}
\description{
This function takes a fit object from ctsem and computes the continuous time autocorrelation
function (ACF) on the standardized residuals.
}
\details{
This function first extracts the standardized residuals from the fit object using
the \code{\link{ctStanKalman}} function. Then, it calculates the continuous time ACF for these residuals
and returns the results as a data table.
}
\examples{
data.table::setDTthreads(1) #ignore this line
# Example usage:
ctACFresiduals(ctstantestfit, varnames='Y1',nboot=5)

}
\seealso{
\code{\link{ctStanKalman}}
}
