% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logistic_reg.R
\name{cuda_ml_logistic_reg}
\alias{cuda_ml_logistic_reg}
\alias{cuda_ml_logistic_reg.default}
\alias{cuda_ml_logistic_reg.data.frame}
\alias{cuda_ml_logistic_reg.matrix}
\alias{cuda_ml_logistic_reg.formula}
\alias{cuda_ml_logistic_reg.recipe}
\title{Train a logistic regression model.}
\usage{
cuda_ml_logistic_reg(x, ...)

\method{cuda_ml_logistic_reg}{default}(x, ...)

\method{cuda_ml_logistic_reg}{data.frame}(
  x,
  y,
  fit_intercept = TRUE,
  penalty = c("l2", "l1", "elasticnet", "none"),
  tol = 1e-04,
  C = 1,
  class_weight = NULL,
  sample_weight = NULL,
  max_iters = 1000L,
  linesearch_max_iters = 50L,
  l1_ratio = NULL,
  ...
)

\method{cuda_ml_logistic_reg}{matrix}(
  x,
  y,
  fit_intercept = TRUE,
  penalty = c("l2", "l1", "elasticnet", "none"),
  tol = 1e-04,
  C = 1,
  class_weight = NULL,
  sample_weight = NULL,
  max_iters = 1000L,
  linesearch_max_iters = 50L,
  l1_ratio = NULL,
  ...
)

\method{cuda_ml_logistic_reg}{formula}(
  formula,
  data,
  fit_intercept = TRUE,
  penalty = c("l2", "l1", "elasticnet", "none"),
  tol = 1e-04,
  C = 1,
  class_weight = NULL,
  sample_weight = NULL,
  max_iters = 1000L,
  linesearch_max_iters = 50L,
  l1_ratio = NULL,
  ...
)

\method{cuda_ml_logistic_reg}{recipe}(
  x,
  data,
  fit_intercept = TRUE,
  penalty = c("l2", "l1", "elasticnet", "none"),
  tol = 1e-04,
  C = 1,
  class_weight = NULL,
  sample_weight = NULL,
  max_iters = 1000L,
  linesearch_max_iters = 50L,
  l1_ratio = NULL,
  ...
)
}
\arguments{
\item{x}{Depending on the context:

  * A __data frame__ of predictors.
  * A __matrix__ of predictors.
  * A __recipe__ specifying a set of preprocessing steps
  * created from [recipes::recipe()].
  * A __formula__ specifying the predictors and the outcome.}

\item{...}{Optional arguments; currently unused.}

\item{y}{A numeric vector (for regression) or factor (for classification) of
desired responses.}

\item{fit_intercept}{If TRUE, then the model tries to correct for the global
mean of the response variable. If FALSE, then the model expects data to be
centered. Default: TRUE.}

\item{penalty}{The penalty type, must be one of
{"none", "l1", "l2", "elasticnet"}.
If "none" or "l2" is selected, then L-BFGS solver will be used.
If "l1" is selected, solver OWL-QN will be used.
If "elasticnet" is selected, OWL-QN will be used if l1_ratio > 0, otherwise
L-BFGS will be used. Default: "l2".}

\item{tol}{Tolerance for stopping criteria. Default: 1e-4.}

\item{C}{Inverse of regularization strength; must be a positive float.
Default: 1.0.}

\item{class_weight}{If \code{NULL}, then each class has equal weight of
\code{1}.
If \code{class_weight} is set to \code{"balanced"}, then weights will be
inversely proportional to class frequencies in the input data.
If otherwise, then \code{class_weight} must be a named numeric vector of
weight values, with names being class labels.
If \code{class_weight} is not \code{NULL}, then each entry in
\code{sample_weight} will be adjusted by multiplying its original value
with the class weight of the corresponding sample's class.
Default: NULL.}

\item{sample_weight}{Array of weights assigned to individual samples.
If \code{NULL}, then each sample has an equal weight of 1. Default: NULL.}

\item{max_iters}{Maximum number of solver iterations. Default: 1000L.}

\item{linesearch_max_iters}{Max number of linesearch iterations per outer
iteration used in the LBFGS- and OWL- QN solvers. Default: 50L.}

\item{l1_ratio}{The Elastic-Net mixing parameter, must \code{NULL} or be
within the range of [0, 1]. Default: NULL.}

\item{formula}{A formula specifying the outcome terms on the left-hand side,
and the predictor terms on the right-hand side.}

\item{data}{When a __recipe__ or __formula__ is used, \code{data} is
specified as a  __data frame__ containing the predictors and (if
applicable) the outcome.}
}
\description{
Train a logistic regression model using Quasi-Newton (QN) algorithms (i.e.,
Orthant-Wise Limited Memory Quasi-Newton (OWL-QN) if there is L1
regularization, Limited Memory BFGS (L-BFGS) otherwise).
}
\examples{
library(cuda.ml)

X <- scale(as.matrix(iris[names(iris) != "Species"]))
y <- iris$Species

model <- cuda_ml_logistic_reg(X, y, max_iters = 100)
predictions <- predict(model, X)

# NOTE: if we were only performing binary classifications (e.g., by having
# `iris_data <- iris \%>\% mutate(Species = (Species == "setosa"))`), then the
# above would be conceptually equivalent to the following:
#
# iris_data <- iris \%>\% mutate(Species = (Species == "setosa"))
# model <- glm(
#   Species ~ ., data = iris_data, family = binomial(link = "logit"),
#   control = glm.control(epsilon = 1e-8, maxit = 100)
# )
#
# predict(model, iris_data, type = "response")
}
