% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cytometree_package.R
\docType{package}
\name{cytometree-package}
\alias{cytometree}
\alias{cytometree-package}
\title{cytometree: Automated Cytometry Gating and Annotation}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

Given the hypothesis of a bi-modal distribution of cells for each marker, the algorithm constructs a binary tree, the nodes of which are subpopulations of cells. At each node, observed cells and markers are modeled by both a family of normal distributions and a family of bi-modal normal mixture distributions. Splitting is done according to a normalized difference of AIC between the two families. Method is detailed in: Commenges, Alkhassim, Gottardo, Hejblum & Thiebaut (2018) \doi{ 10.1002/cyto.a.23601}.
}
\details{
The main function in this package is \code{\link{CytomeTree}}.
\tabular{ll}{
Package: \tab cytometree\cr
Type: \tab Package\cr
Version: \tab 2.0.6\cr
Date: \tab 2025-07-24\cr
License:\tab \href{http://www.gnu.org/licenses/lgpl.txt}{LGPL-3}\cr
}
The algorithm is based on the construction of a binary tree, 
the nodes of which are subpopulations of cells. At each node, 
observed cells and markers are modeled by both a family of normal
distributions and a family of bi-modal normal mixture distributions. 
Splitting is done according to a normalized difference of AIC between 
the two families.
Given the unsupervised nature of the binary tree, some of the available
markers may not be used to find the different cell populations present in 
a given sample. To recover a complete annotation, we defined, as a post 
processing procedure, an annotation method which allows the user to 
distinguish two or three expression levels per marker.
}
\references{
Commenges D, Alkhassim C, Gottardo R, Hejblum BP, Thiébaut R (2018). 
cytometree: a binary tree algorithm for automatic gating in cytometry analysis. 
Cytometry Part A, 93(11):1132-1140. <doi: 10.1002/cyto.a.23601>
}
\seealso{
Useful links:
\itemize{
  \item \url{https://sistm.github.io/cytometree/}
  \item \url{https://github.com/sistm/Cytometree/}
  \item Report bugs at \url{https://github.com/sistm/Cytometree/issues}
}

}
\author{
\strong{Maintainer}: Boris P Hejblum \email{boris.hejblum@u-bordeaux.fr}

Authors:
\itemize{
  \item Chariff Alkhassim
  \item Anthony Devaux
  \item Van Hung Huynh Tran
  \item Melany Durand
}

}
