
<!-- README.md is generated from README.Rmd. Please edit that file -->

# <img src='https://raw.githubusercontent.com/cefet-rj-dal/daltoolbox/master/inst/logo.png' align='centre' height='150' width='139'/> DAL Toolbox

<!-- badges: start -->

![GitHub Repo
stars](https://img.shields.io/github/stars/cefet-rj-dal/daltoolbox?logo=Github)
![GitHub Repo stars](https://cranlogs.r-pkg.org/badges/daltoolbox)
<!-- badges: end -->

As research experiments grow in scale and complexity, data analytics
demands tools that go beyond isolated functions. DAL Toolbox is a
framework designed to meet these modern challenges by organizing a
comprehensive set of data analytics capabilities into an integrated
workflow environment. Inspired by the Experiment Line model
<doi:10.1007/978-3-642-02279-1_20>, it supports essential tasks such as
data preprocessing, classification, regression, clustering, and time
series prediction. With a unified data model, consistent method API, and
support for hyperparameter tuning, DAL Toolbox enables the seamless
construction and execution of end-to-end analytics pipelines. It also
offers easy integration with existing libraries and languages, promoting
usability, extensibility, and reproducibility in data science.

------------------------------------------------------------------------

## Examples

Graphics:
<https://github.com/cefet-rj-dal/daltoolbox/tree/main/graphics/>

Transformation:
<https://github.com/cefet-rj-dal/daltoolbox/tree/main/transf/>

Classification:
<https://github.com/cefet-rj-dal/daltoolbox/tree/main/classification/>

Clustering:
<https://github.com/cefet-rj-dal/daltoolbox/tree/main/clustering/>

Regression:
<https://github.com/cefet-rj-dal/daltoolbox/tree/main/regression/>

The examples are organized according to general (data preprocessing),
clustering, classification, regression, and time series functions.

------------------------------------------------------------------------

## Installation

The latest version of DAL Toolbox at CRAN is available at:
<https://CRAN.R-project.org/package=daltoolbox>

You can install the stable version of DAL Toolbox from CRAN with:

``` r
install.packages("daltoolbox")
```

You can install the development version of DAL Toolbox from GitHub
<https://github.com/cefet-rj-dal/daltoolbox> with:

``` r
library(devtools)
devtools::install_github("cefet-rj-dal/daltoolbox", force=TRUE, dependencies=FALSE, upgrade="never")
```

------------------------------------------------------------------------

## Bugs and new features request

<https://github.com/cefet-rj-dal/daltoolbox/issues>
