% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans_categ_mapping.R
\name{categ_mapping}
\alias{categ_mapping}
\title{Categorical mapping (one‑hot encoding)}
\usage{
categ_mapping(attribute)
}
\arguments{
\item{attribute}{attribute to be categorized.}
}
\value{
returns a data frame with binary attributes, one for each possible category.
}
\description{
Convert a factor column into dummy variables (one‑hot encoding) using \code{model.matrix} without intercept.
Each level becomes a separate binary column.
}
\details{
This is a light wrapper around \code{stats::model.matrix(~ attr - 1, data)} that drops the original column
and returns only the dummy variables.
}
\examples{
cm <- categ_mapping("Species")
iris_cm <- transform(cm, iris)

# can be made in a single column
species <- iris[,"Species", drop=FALSE]
iris_cm <- transform(cm, species)
}
