% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/daterangepicker.R
\name{daterangepicker}
\alias{daterangepicker}
\title{daterangepicker}
\usage{
daterangepicker(
  inputId = NULL,
  label = "Select a Date",
  start = NULL,
  end = NULL,
  min = NULL,
  max = NULL,
  ranges = NULL,
  rangeNames = names(ranges),
  language = "en",
  style = "width:100\%;border-radius:4px;text-align:center;",
  class = NULL,
  icon = NULL,
  options = daterangepickerOptions()
)
}
\arguments{
\item{inputId}{The input ID}

\item{label}{The label for the control, or NULL for no label.}

\item{start}{The beginning date of the initially selected. Must be a Date /
POSIXt or string. If NULL will default to the current day.}

\item{end}{The end date of the initially selected date range. Must be a Date
/ POSIXt or string. If NULL will default to the current day.}

\item{min}{The earliest date a user may select. Must be a Date or string}

\item{max}{The latest date a user may select. Must be a Date or string}

\item{ranges}{Set predefined date ranges the user can select from. Each key
is the label for the range, and its value an array with two dates
representing the bounds of the range.
Alternatively, the labels can be specified via `rangeNames`. If that
argument is used, `ranges` should not be named and `rangeNames` will
take precedence.}

\item{rangeNames}{Optional character vector specifying the labels for
predefined date ranges. If specified, it will override the names
of `ranges`.}

\item{language}{The language used for month and day names. Default is "en".
See the \href{https://momentjs.com/}{Multiple Locale Support} for a list of
other valid values.}

\item{style}{Add CSS-styles to the input.}

\item{class}{Custom class}

\item{icon}{Icon to display next to the label.}

\item{options}{List of further options. See
\code{\link{daterangepickerOptions}}}
}
\description{
The Date Range Picker pops up two calendars for selecting dates, times, or
predefined ranges like "Yesterday", "Last 30 Days", etc.
}
\examples{
if (interactive()) {
  library(shiny)
  library(daterangepicker)
  ## UI ##########################
  ui <- fluidPage(
    tags$head(tags$style(".myclass {background-color: #96dafb;}")),
    daterangepicker(
      inputId = "daterange",
      label = "Pick a Date",
      start = Sys.Date() - 30, end = Sys.Date(),
      max = Sys.Date(),
      language = "en",
      ranges = list(
        "Today" = Sys.Date(),
        "Yesterday" = Sys.Date() - 1,
        "Last 3 days" = c(Sys.Date() - 2, Sys.Date()),
        "Last 7 days" = c(Sys.Date() - 6, Sys.Date())
      ),
      style = "width:100\%; border-radius:4px",
      class = "myclass",
      icon = icon("calendar")
    ),
    verbatimTextOutput("print"),
    actionButton("act", "Update Daterangepicker"),
  )
  ## SERVER ##########################
  server <- function(input, output, session) {
    output$print <- renderPrint({
      req(input$daterange)
      input$daterange
    })
    observeEvent(input$act, {
      updateDaterangepicker(
        session, "daterange",
        start = Sys.Date(),
        end = Sys.Date() - 100,
        ranges = list(
          Sys.Date(), Sys.Date() - 1,
          c(Sys.Date() - 3, Sys.Date()),
          c(Sys.Date() - 6, Sys.Date()),
          Sys.Date() + 2
        ),
        rangeNames = c(
          "Today", "Yesterday", "Last 3 days",
          "Last 7 days", "The day after tomorrow \u263a"
        ),
        max = Sys.Date() + 2
      )
    })
  }
  shinyApp(ui, server)
}
}
\seealso{
\href{https://www.daterangepicker.com/#config}{www.daterangepicker.com}

Other daterangepicker Functions: 
\code{\link{daterangepickerOptions}()},
\code{\link{updateDaterangepicker}()}
}
\concept{daterangepicker Functions}
