% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scenario.R
\name{summary.Scenario.object}
\alias{summary.Scenario.object}
\title{summary.Scenario object}
\arguments{
\item{treatment.effect}{The exp(mean(log(individual treatment effects))),}

\item{se}{The mean standard error of the (log) treatment effect}

\item{power}{The proportion of simulations for which the p-value is \code{< alpha}}

\item{alpha}{The significance level used when calculating power, by default 0.05 use
\code{summary(object,alpha=x)} to use a different p value}

\item{use.adjusted.pval}{logical, default FALSE should the p values calculated using
Rubin's formula with the adjusted number of degrees of freedom be used. Use \code{summary(object,use.adjusted.pval=TRUE)},
to use the adjusted p values}

\item{description}{A string containing a description of the scenario}

\item{dropout}{A list of summary statistics regarding number of subject dropouts}
}
\description{
This object contains the overall summary statistics for a specific
scenario. It is envisioned that multiple scenarios are run and a set of
\code{summary.Scenario} objects are created and these can then be used for
plotting
}
\details{
A \code{print.summary.Scenario} function has been implemented
}
