% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manual.R
\name{trim_manually}
\alias{trim_manually}
\title{Manually trim a list of density profiles}
\usage{
trim_manually(dp.list)
}
\arguments{
\item{dp.list}{A list of dp objects.}
}
\value{
A list of trimmed density profiles.
}
\description{
This function will take a list of dp objects and interactively ask
the user to assign starting/ending points manually for all density
profiles in sequentially. Used as alternative to automatic trim
functions. The plot title will display whether you are selecting
start or end position. Use your mouse to select starting/ending
points on the plot.
}
\examples{
## load all dp files
\donttest{
dp.list <- dpload(dp.directory = system.file("extdata", package = "densitr"))
## manually trim the list
dp.trimmed <- trim_manually(dp.list)
}
}
\seealso{
dptrim, dptriml, manual_trim_detect
}
